<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';

$divisi = $_GET['divisi'] ?? 'ACD';

$todos = $conn->query("
    SELECT ut.*, 
           CASE 
               WHEN ut.source_type = 'activity' THEN a.name
               WHEN ut.source_type = 'focus' THEN f.name
               WHEN ut.source_type = 'procurement' THEN p.name
           END as source_name
    FROM unified_todos ut
    LEFT JOIN activities a ON ut.source_type = 'activity' AND ut.source_id = a.id
    LEFT JOIN focuses f ON ut.source_type = 'focus' AND ut.source_id = f.id
    LEFT JOIN procurements p ON ut.source_type = 'procurement' AND ut.source_id = p.id
    WHERE ut.divisi = '$divisi'
    ORDER BY ut.due_date
");
// Remove these queries:
$monthly_stats = $conn->query("
    SELECT 
        DATE_FORMAT(due_date, '%Y-%m') as month,
        COUNT(*) as total,
        SUM(CASE WHEN status = 'completed' THEN 1 ELSE 0 END) as completed,
        SUM(CASE WHEN status = 'pending' AND due_date >= CURDATE() THEN 1 ELSE 0 END) as pending,
        SUM(CASE WHEN status = 'pending' AND due_date < CURDATE() THEN 1 ELSE 0 END) as exceeded,
        SUM(CASE WHEN status = 'failed' THEN 1 ELSE 0 END) as failed
    FROM unified_todos
    WHERE divisi = '$divisi'
    GROUP BY DATE_FORMAT(due_date, '%Y-%m')
    ORDER BY month DESC
");

$yearly_stats = $conn->query("
    SELECT 
        YEAR(due_date) as year,
        COUNT(*) as total,
        SUM(CASE WHEN status = 'completed' THEN 1 ELSE 0 END) as completed,
        SUM(CASE WHEN status = 'pending' AND due_date >= CURDATE() THEN 1 ELSE 0 END) as pending,
        SUM(CASE WHEN status = 'pending' AND due_date < CURDATE() THEN 1 ELSE 0 END) as exceeded,
        SUM(CASE WHEN status = 'failed' THEN 1 ELSE 0 END) as failed
    FROM unified_todos
    WHERE divisi = '$divisi'
    GROUP BY YEAR(due_date)
    ORDER BY year DESC
");
// Replace the $acd_comments query with this:
$acd_comments = $conn->query("
    SELECT uc.*, u.name as created_by_name,
           CASE 
               WHEN uc.source_type = 'activity' THEN a.name
               WHEN uc.source_type = 'focus' THEN f.name
               WHEN uc.source_type = 'procurement' THEN p.name
           END as source_name
    FROM unified_comments uc
    JOIN users u ON uc.created_by = u.username
    LEFT JOIN activities a ON uc.source_type = 'activity' AND uc.source_id = a.id
    LEFT JOIN focuses f ON uc.source_type = 'focus' AND uc.source_id = f.id
    LEFT JOIN procurements p ON uc.source_type = 'procurement' AND uc.source_id = p.id
    WHERE LOWER(uc.type) = 'acd'
    ORDER BY uc.created_at DESC
    LIMIT 20
") or die("Query failed: " . $conn->error);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
    <link href="../assets/css/dashboard.css" rel="stylesheet">
    <style>
        .comment-item {
            padding: 10px;
            border-radius: 5px;
            background-color: #f8f9fa;
        }
        .comment-content {
            white-space: pre-wrap;
        }
    </style>
</head>
<body>
<?php include 'includes/header.php'; ?>

<div class="container-fluid">
    <div class="row">
        <?php include 'includes/sidebar.php'; ?>
        
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">To-Do List ACD</h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <div class="btn-group me-2">
                        <button type="button" class="btn btn-sm btn-outline-secondary">
                            <i class="bi bi-download"></i> Export
                        </button>
                        <button type="button" class="btn btn-sm btn-outline-secondary">
                            <i class="bi bi-share"></i> Share
                        </button>
                    </div>
                    <div class="btn-group">
                        <button type="button" class="btn btn-sm btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
                            <i class="bi bi-funnel"></i> Filter
                        </button>
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- Left Column (8 units) - Todo List -->
                <div class="col-md-12"> <!-- Changed from col-md-8 to col-md-12 -->
                    <!-- Todo List Section -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5>To-Do List ACD</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Jenis</th>
                                            <th>Nama Todo</th>
                                            <th>Sumber</th>
                                            <th>Keterangan</th>
                                            <th>Due Date</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while($todo = $todos->fetch_assoc()): ?>
                                        <tr>
                                            <td><?= htmlspecialchars(ucfirst($todo['source_type'])) ?></td>
                                            <td><?= htmlspecialchars($todo['title']) ?></td>
                                            <td><?= htmlspecialchars($todo['source_name'] ?? 'N/A') ?></td>
                                            <td><?= htmlspecialchars($todo['keterangan']) ?></td>
                                            <td><?= date('d M Y', strtotime($todo['due_date'])) ?></td>
                                            <td>
                                                <span class="badge <?= $todo['status'] == 'completed' ? 'bg-success' : 'bg-warning' ?>">
                                                    <?= ucfirst($todo['status']) ?>
                                                </span>
                                            </td>
                                            <td>
                                                <button class="btn btn-sm btn-outline-primary me-1">Edit</button>
                                                <button class="btn btn-sm btn-outline-danger">Delete</button>
                                            </td>
                                        </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- ACD Comments Section -->
                    <div class="card mt-4">
                        <div class="card-header">
                            <h5>Komentar ACD</h5>
                        </div>
                        <div class="card-body">
                            <div class="comment-list">
                                <?php if($acd_comments->num_rows > 0): ?>
                                    <?php while($comment = $acd_comments->fetch_assoc()): ?>
                                    <div class="comment-item mb-3 p-3 border-bottom">
                                        <div class="d-flex justify-content-between">
                                            <strong><?= htmlspecialchars($comment['created_by_name']) ?></strong>
                                            <small class="text-muted">
                                                <?= date('d M Y H:i', strtotime($comment['created_at'])) ?>
                                            </small>
                                        </div>
                                        <div class="comment-content mt-2">
                                            <?= nl2br(htmlspecialchars($comment['comment'])) ?>
                                        </div>
                                        <span class="badge bg-acd mt-2">
                                            <?= strtoupper($comment['type']) ?>
                                        </span>
                                    </div>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <p class="text-muted">Belum ada komentar</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Remove the entire right column (statistics section) -->
            </div>
        </main>
    </div>
</div>

// Remove all statistics-related divs after the footer include
<?php include 'includes/footer.php'; ?>

// Change any links like this:
<a href="procurement.php#procurementSubmenu">Pengadaan</a>
<a href="focus.php#focusSubmenu">Fokus</a>

// Add this after the filter buttons section
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5>Monthly Statistics</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>Month</th>
                                <th>Total</th>
                                <th>Completed</th>
                                <th>Pending</th>
                                <th>Exceeded</th>
                                <th>Failed</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($stat = $monthly_stats->fetch_assoc()): ?>
                            <tr>
                                <td><?= $stat['month'] ?></td>
                                <td><?= $stat['total'] ?></td>
                                <td class="text-success"><?= $stat['completed'] ?></td>
                                <td class="text-primary"><?= $stat['pending'] ?></td>
                                <td class="text-warning"><?= $stat['exceeded'] ?></td>
                                <td class="text-danger"><?= $stat['failed'] ?></td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5>Yearly Statistics</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>Year</th>
                                <th>Total</th>
                                <th>Completed</th>
                                <th>Pending</th>
                                <th>Exceeded</th>
                                <th>Failed</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($stat = $yearly_stats->fetch_assoc()): ?>
                            <tr>
                                <td><?= $stat['year'] ?></td>
                                <td><?= $stat['total'] ?></td>
                                <td class="text-success"><?= $stat['completed'] ?></td>
                                <td class="text-primary"><?= $stat['pending'] ?></td>
                                <td class="text-warning"><?= $stat['exceeded'] ?></td>
                                <td class="text-danger"><?= $stat['failed'] ?></td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>