<?php
require_once 'includes/config.php';
//require_once 'includes/auth.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $date = $_POST['date'];
    $end_date = $_POST['end_date'];
    $person_in_charge = $_POST['person_in_charge'];
    // {{ Process selected units (checkboxes send an array) }}
    $units_array = $_POST['unit'] ?? []; // Get the array of selected units, default to empty array if none selected
    $unit_string = implode(',', $units_array); // Convert array to comma-separated string
    // {{ End unit processing }}
    $spotlight = $_POST['spotlight'];
    $notes = $_POST['notes'];
    $due_date = $_POST['due_date'];
    $status = $_POST['status'];

    // {{ Update the INSERT statement and bind_param for the new 'unit' column }}
    $stmt = $conn->prepare("INSERT INTO activities (name, date, end_date, person_in_charge, unit, spotlight, status, notes, due_date) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    // Note: The number of 's' characters must match the number of question marks. Added 's' for unit.
    $stmt->bind_param("ssssssss", $name, $date, $end_date, $person_in_charge, $unit_string, $spotlight, $status, $notes, $due_date);
    $stmt->execute();
    $stmt->close();

    header("Location: activities.php?success=1");
    exit();
}

// {{ Fetch the unit column in the SELECT query }}
$activities = $conn->query("SELECT id, name, date, end_date, person_in_charge, unit, spotlight, status, notes FROM activities ORDER BY date DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Kegiatan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-3">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
                    <h1 class="h2">Data Kegiatan</h1>
                    <div class="btn-group">
                        <a href="activities.php" class="btn btn-sm btn-outline-secondary">Daftar Kegiatan</a>
                        <a href="activity_detail.php" class="btn btn-sm btn-outline-secondary active">Detail Kegiatan</a>
                        <a href="activity_todos.php" class="btn btn-sm btn-outline-secondary">To-Do List</a>
                        <a href="activity_meetings.php" class="btn btn-sm btn-outline-secondary">Notulen Rapat</a>
                    </div>
                </div>

                <!-- Add Activity Form -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5>Tambah Kegiatan Baru</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST">
                            <div class="mb-3">
                                <label class="form-label">Nama Kegiatan</label>
                                <input type="text" class="form-control" name="name" required>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Tanggal Mulai</label>
                                        <input type="date" class="form-control" name="date" id="start_date" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Tanggal Selesai</label>
                                        <input type="date" class="form-control" name="end_date" id="end_date" required>
                                    </div>
                                </div>
                            </div>

                            {{# Add Unit Checkboxes #}}
                            <div class="mb-3">
                                <label class="form-label">Unit Terkait</label>
                                <div>
                                    <?php
                                    $unit_options = ['TKIT', 'SDIT', 'MTS', 'MA', 'YAYASAN', 'ACD', 'KEUANGAN', 'OPERATOR', 'STAF', 'DAPUR'];
                                    foreach ($unit_options as $unit_opt) {
                                        echo '<div class="form-check form-check-inline">';
                                        echo '<input class="form-check-input" type="checkbox" name="unit[]" value="' . htmlspecialchars($unit_opt) . '" id="unit_' . htmlspecialchars($unit_opt) . '">';
                                        echo '<label class="form-check-label" for="unit_' . htmlspecialchars($unit_opt) . '">' . htmlspecialchars($unit_opt) . '</label>';
                                        echo '</div>';
                                    }
                                    ?>
                                </div>
                            </div>
                            {{# End Unit Checkboxes #}}

                            <div class="mb-3">
                                <label class="form-label">Spotlight</label>
                                <select class="form-select" name="spotlight" required>
                                    <option value="Pengawasan Khusus">Pengawasan Khusus</option>
                                    <option value="Pengawasan Cukup">Pengawasan Cukup</option>
                                    <option value="Normal" selected>Normal</option>
                                </select>
                            </div>

                            {{-- Add the Status dropdown (assuming it was added previously) --}}
                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <select class="form-select" name="status" required>
                                    <option value="pending" selected>Pending</option>
                                    <option value="onprogress">On Progress</option>
                                    <option value="completed">Completed</option>
                                    <option value="canceled">Canceled</option>
                                    <option value="must be evaluated">Must Be Evaluated</option>
                                </select>
                            </div>

                            <!-- Remove due_date field -->

                            <div class="mb-3">
                                <label class="form-label">Catatan</label>
                                <textarea class="form-control" name="notes" rows="3"></textarea>
                            </div>
                            
                            <button type="submit" class="btn btn-primary">Simpan</button>
                        </form>
                    </div>
                </div>

                <!-- Activity List -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Tanggal Mulai</th>
                                        <th>Tanggal Selesai</th>
                                        <th>Nama</th>
                                        <th>Penanggung Jawab</th>
                                        <th>Unit</th> {{-- Add Unit header --}}
                                        <th>Spotlight</th>
                                        <th>Status</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while($activity = $activities->fetch_assoc()): ?>
                                    <tr>
                                        <td><?= date('d M Y', strtotime($activity['date'])) ?></td>
                                        <td><?= date('d M Y', strtotime($activity['end_date'])) ?></td>
                                        <td><?= htmlspecialchars($activity['name']) ?></td>
                                        <td><?= htmlspecialchars($activity['person_in_charge']) ?></td>
                                        <td><?= htmlspecialchars($activity['unit']) ?></td>
                                        <td><?= htmlspecialchars($activity['spotlight']) ?></td>
                                        <td><span class="badge <?= $status_badge_class ?>"><?= htmlspecialchars(ucfirst(str_replace('_', ' ', $activity['status']))) ?></span></td>
                                        <td>
                                            <a href="activity_detail.php?id=<?= $activity['id'] ?>" class="btn btn-sm btn-info">Detail</a>
                                            {{-- Add Edit/Delete buttons here if needed --}}
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>
<script>
        // Set default start date to today
        document.getElementById('start_date').valueAsDate = new Date();
        
        // Set default end date to match start date
        document.getElementById('end_date').valueAsDate = new Date();
        
        // Update end date when start date changes
        document.getElementById('start_date').addEventListener('change', function() {
            const startDate = this.value;
            const endDateInput = document.getElementById('end_date');
            
            // Set minimum date for end date
            endDateInput.min = startDate;
            
            // If end date is before start date, update it
            if (endDateInput.value < startDate) {
                endDateInput.value = startDate;
            }
        });
    </script>
</body>
</html>