<?php
require_once 'includes/config.php';
// Optional: Add authentication check if needed
// require_once 'includes/auth.php'; 

// Check if the form was submitted via POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // --- Data Retrieval ---
    // Get data from POST request, using null coalescing operator for safety
    $source_type = $_POST['source_type'] ?? null;
    $source_id = isset($_POST['source_id']) ? (int)$_POST['source_id'] : null; // Ensure it's an integer
    $item_name = $_POST['item_name'] ?? null;
    $quantity_needed = isset($_POST['quantity_needed']) ? (float)$_POST['quantity_needed'] : null; // Ensure it's a float/decimal
    $unit = $_POST['unit'] ?? null; // Unit is optional
    $notes = $_POST['notes'] ?? null; // Notes are optional

    // --- Basic Validation ---
    // Check if required fields are present and valid
    if (empty($source_type) || empty($source_id) || empty($item_name) || $quantity_needed === null || $quantity_needed < 0) {
        // Handle error - redirect back with an error message or display an error page
        // For simplicity, redirecting back to the referring page (usually the detail page)
        // You might want to add session flash messages for better user feedback
        error_log("Validation failed for adding item: Missing required fields or invalid quantity.");
        header("Location: " . $_SERVER['HTTP_REFERER'] ?? 'activities.php'); // Redirect back
        exit();
    }

    // Sanitize optional fields (trim whitespace)
    $unit = !empty($unit) ? trim($unit) : null;
    $notes = !empty($notes) ? trim($notes) : null;

    // --- Database Insertion ---
    // Prepare SQL statement to prevent SQL injection
    $sql = "INSERT INTO unified_item_list (source_type, source_id, item_name, quantity_needed, unit, notes, status) 
            VALUES (?, ?, ?, ?, ?, ?, 'pending')"; // Default status to 'pending'

    $stmt = $conn->prepare($sql);

    if ($stmt) {
        // Bind parameters (s = string, i = integer, d = double/decimal)
        // Adjust types if your column types differ significantly
        $stmt->bind_param("sisdss", 
            $source_type, 
            $source_id, 
            $item_name, 
            $quantity_needed, 
            $unit, 
            $notes
        );

        // Execute the statement
        if ($stmt->execute()) {
            // Success: Redirect back to the activity detail page
            header("Location: activity_detail.php?id=" . $source_id);
            exit();
        } else {
            // Error during execution
            error_log("Error executing item insert statement: " . $stmt->error);
            // Handle error (e.g., display generic error message or redirect)
            echo "Terjadi kesalahan saat menyimpan item. Silakan coba lagi."; 
            // Consider redirecting with an error flag
        }
        // Close statement
        $stmt->close();
    } else {
        // Error preparing statement
        error_log("Error preparing item insert statement: " . $conn->error);
        // Handle error
        echo "Terjadi kesalahan pada sistem. Silakan coba lagi nanti.";
    }

    // Close connection (optional, often handled automatically at script end)
    // $conn->close();

} else {
    // If not a POST request, redirect to a safe page (e.g., activities list)
    header("Location: activities.php");
    exit();
}
?>