<?php
require_once 'includes/config.php';
//require_once 'includes/auth.php';

$id = $_GET['id'] ?? null;
if (!$id) {
    header("Location: activities.php");
    exit();
}

$activity = $conn->query("SELECT * FROM activities WHERE id = $id")->fetch_assoc();
if (!$activity) {
    header("Location: activities.php");
    exit();
}

$todos = $conn->query("SELECT * FROM unified_todos WHERE source_type = 'activity' AND source_id = $id ORDER BY due_date");
$meetings = $conn->query("SELECT * FROM unified_meetings WHERE source_type = 'activity' AND source_id = $id ORDER BY meeting_date DESC");
// Add this query at the top with other queries
$comments = $conn->query("
    SELECT c.*, u.name as created_by_name 
    FROM unified_comments c
    JOIN users u ON c.created_by = u.username
    WHERE c.source_type = 'activity' 
    AND c.source_id = $id
    ORDER BY c.created_at DESC
");

// Debug: Check if comments query was successful and if it returned rows
if (!$comments) {
    error_log("Error fetching comments: " . $conn->error);
} else {
    error_log("Number of comments fetched: " . $comments->num_rows);
}

// Add this query to fetch items
$items = $conn->query("
    SELECT * 
    FROM unified_item_list 
    WHERE source_type = 'activity' 
    AND source_id = $id 
    ORDER BY created_at ASC
");

// Debug: Check if items query was successful
if (!$items) {
    error_log("Error fetching items: " . $conn->error);
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Detail Kegiatan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-3">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
                    <h1 class="h2">Detail Kegiatan: <?= htmlspecialchars($activity['name']) ?></h1>
                    <div class="btn-group">
                        <a href="activities.php" class="btn btn-sm btn-outline-secondary">Daftar Kegiatan</a>
                        <a href="activity_detail.php?id=<?= $id ?>" class="btn btn-sm btn-outline-secondary active">Detail Kegiatan</a>
                        <a href="activity_todos.php?id=<?= $id ?>" class="btn btn-sm btn-outline-secondary">To-Do List</a>
                        <a href="activity_meetings.php?id=<?= $id ?>" class="btn btn-sm btn-outline-secondary">Notulen Rapat</a>
                    </div>
                </div>

                <!-- Basic Info Section -->
                <div class="card mb-4">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <p><strong>Tanggal:</strong> 
                                    <?= date('d M Y', strtotime($activity['date'])) ?> 
                                    - 
                                    <?= date('d M Y', strtotime($activity['end_date'] ?? $activity['date'])) ?>
                                </p>
                                <p><strong>Penanggung Jawab:</strong> <?= htmlspecialchars($activity['person_in_charge']) ?></p>
                            </div>
                            <div class="col-md-6">
                                <p><strong>Status:</strong> <?= htmlspecialchars($activity['spotlight']) ?></p>
                            </div>
                        </div>
                        <p><strong>Catatan:</strong><br><?= nl2br(htmlspecialchars($activity['notes'])) ?></p>
                    </div>
                </div>

                <!-- Main Content Section -->
                <div class="row">
                    <!-- Left Column (8 units) -->
                    <div class="col-md-8">
                        <!-- To-Do List Section -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5>To-Do List</h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Divisi</th>
                                            <th>Task</th>
                                            <th>Keterangan</th>
                                            <th>Due Date</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while($todo = $todos->fetch_assoc()): ?>
                                        <tr>
                                            <td><?= htmlspecialchars($todo['divisi']) ?></td>
                                            <td><?= htmlspecialchars($todo['title']) ?></td>
                                            <td><?= htmlspecialchars($todo['keterangan']) ?></td>
                                            <td><?= date('d M Y', strtotime($todo['due_date'])) ?></td>
                                            <td>
                                                <form action="unified_toggle_todo.php" method="POST" class="d-inline">
                                                    <input type="hidden" name="todo_id" value="<?= $todo['id'] ?>">
                                                    <input type="hidden" name="source_type" value="activity">
                                                    <input type="hidden" name="source_id" value="<?= $id ?>">
                                                    <button type="submit" class="btn btn-sm <?= $todo['status'] == 'completed' ? 'btn-success' : 'btn-warning' ?>">
                                                        <?= ucfirst($todo['status']) ?>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addTodoModal">
                                    Tambah To-Do
                                </button>
                            </div>
                        </div>
                        
                        <!-- Item List Section -->
                        <div class="card mb-4">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h5>Daftar Item Dibutuhkan</h5>
                                <!-- Optional: Add button for adding items later -->
                                <!-- <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#addItemModal">Tambah Item</button> -->
                            </div>
                            <div class="card-body">
                                <?php if ($items && $items->num_rows > 0): ?>
                                <div class="table-responsive"> <!-- Added for small screens -->
                                    <table class="table table-sm table-hover mb-0"> <!-- Added mb-0 -->
                                        <thead class="table-light"> <!-- Added background to header -->
                                            <tr>
                                                <th scope="col">Nama Item</th>
                                                <th scope="col" class="text-end">Jumlah</th> <!-- Added text-end -->
                                                <th scope="col">Keterangan</th>
                                                <th scope="col" class="text-center">Aksi</th> <!-- Added Actions column -->
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php // Reset pointer if needed
                                                  if ($items) $items->data_seek(0); 
                                            ?>
                                            <?php while($item = $items->fetch_assoc()): 
                                                // Determine button class and next status based on current status
                                                $current_status = $item['status'];
                                                $next_status = 'pending'; // Default fallback
                                                $button_class = 'btn-secondary'; // Default
                                                $button_text = ucfirst($current_status);

                                                switch ($current_status) {
                                                    case 'pending':
                                                        $next_status = 'ordered';
                                                        $button_class = 'btn-warning'; // Yellow for pending
                                                        break;
                                                    case 'ordered':
                                                        $next_status = 'received';
                                                        $button_class = 'btn-info';    // Blue for ordered
                                                        break;
                                                    case 'received':
                                                        $next_status = 'pending'; // Cycle back to pending
                                                        $button_class = 'btn-success'; // Green for received
                                                        break;
                                                    case 'cancelled':
                                                        // If cancelled, maybe disable toggling or have a separate 'reactivate' action
                                                        $next_status = 'pending'; // Or keep as cancelled
                                                        $button_class = 'btn-danger'; // Red for cancelled
                                                        // $button_text = 'Cancelled'; // Keep text as Cancelled
                                                        break;
                                                }
                                            ?>
                                            <tr>
                                                <td><?= htmlspecialchars($item['item_name']) ?></td>
                                                <td class="text-end">
                                                    <?= htmlspecialchars(number_format($item['quantity_needed'], 0)) ?> 
                                                    <small class="text-muted"><?= htmlspecialchars($item['unit'] ?? '') ?></small>
                                                </td> 
                                                <td><?= nl2br(htmlspecialchars($item['notes'] ?? '-')) ?></td> 
                                                <td class="text-center"> 
                                                    <form action="activity_toggle_item_status.php" method="POST" class="d-inline">
                                                        <input type="hidden" name="item_id" value="<?= $item['id'] ?>">
                                                        <input type="hidden" name="next_status" value="<?= $next_status ?>">
                                                        <input type="hidden" name="source_id" value="<?= $id ?>"> <!-- To redirect back -->
                                                        <button type="submit" 
                                                                class="btn btn-sm <?= $button_class ?>" 
                                                                title="Klik untuk ubah ke: <?= ucfirst($next_status) ?>"
                                                                <?= $current_status == 'cancelled' ? 'disabled' : '' ?> > <!-- Disable if cancelled -->
                                                            <?= $button_text ?>
                                                        </button>
                                                    </form>
                                                    <!-- Keep placeholder Edit/Delete buttons if needed, maybe next to the status toggle -->
                                                    <!-- 
                                                    <button class="btn btn-xs btn-outline-secondary ms-1" title="Edit Item" disabled> 
                                                        <i class="fas fa-pencil-alt"></i> 
                                                    </button>
                                                    <button class="btn btn-xs btn-outline-danger" title="Hapus Item" disabled> 
                                                        <i class="fas fa-trash-alt"></i> 
                                                    </button> 
                                                    -->
                                                </td>
                                            </tr>
                                            <?php endwhile; ?>
                                        </tbody>
                                    </table>
                                </div>
                                <?php else: ?>
                                <p class="text-muted">Belum ada item yang ditambahkan untuk kegiatan ini.</p>
                                <?php endif; ?>
                                <!-- Add Item Button -->
                                <button class="btn btn-primary btn-sm mt-3" data-bs-toggle="modal" data-bs-target="#addItemModal">
                                    Tambah Item
                                </button>
                            </div> <!-- End Card Body -->
                        </div> <!-- End Card -->

                        <!-- Meeting Notes Section -->
                        <div class="card">
                            <div class="card-header">
                                <h5>Notulen Rapat</h5>
                            </div>
                            <div class="card-body">
                                <div class="list-group">
                                    <?php while($meeting = $meetings->fetch_assoc()): ?>
                                    <div class="list-group-item">
                                        <h6>Rapat <?= date('d M Y H:i', strtotime($meeting['meeting_date'])) ?></h6>
                                        <p><?= nl2br(htmlspecialchars($meeting['notes'])) ?></p>
                                    </div>
                                    <?php endwhile; ?>
                                </div>
                                <button class="btn btn-primary mt-3" data-bs-toggle="modal" data-bs-target="#addMeetingModal">
                                    Tambah Notulen
                                </button>
                            </div>
                        </div>
                    </div>
                
                    <!-- Right Column (4 units) -->
                    <div class="col-md-4">
                        <!-- Comments Section -->
                        <div class="card">
                            <div class="card-header">
                                <h5>Komentar</h5>
                            </div>
                            <div class="card-body">
                                <?php
                                // Fetch comments (ensure this query is executed earlier in the script)
                                /*
                                $comments = $conn->query("
                                    SELECT c.*, u.name as created_by_name
                                    FROM unified_comments c
                                    JOIN users u ON c.created_by = u.username
                                    WHERE c.source_type = 'activity'
                                    AND c.source_id = $id
                                    ORDER BY c.created_at ASC -- Fetch oldest first for easier hierarchy building
                                ");
                                */

                                // Organize comments into parent-child structure
                                $commentsData = [];
                                if ($comments && $comments->num_rows > 0) {
                                    // Reset pointer if needed, or re-fetch if necessary
                                    // $comments->data_seek(0); // Reset pointer if already iterated
                                    while($comment = $comments->fetch_assoc()) {
                                        $commentsData[] = $comment; // Store all comments first
                                    }
                                }

                                $organizedComments = [];
                                $commentMap = []; // Helper map for quick access

                                // Build map and identify root comments
                                foreach ($commentsData as $comment) {
                                    $comment['replies'] = []; // Initialize replies array
                                    $commentMap[$comment['id']] = $comment;
                                    if ($comment['parent_id'] === null) {
                                        $organizedComments[$comment['id']] = &$commentMap[$comment['id']];
                                    }
                                }

                                // Assign replies to their parents
                                foreach ($commentsData as $comment) {
                                    if ($comment['parent_id'] !== null) {
                                        if (isset($commentMap[$comment['parent_id']])) {
                                            $commentMap[$comment['parent_id']]['replies'][$comment['id']] = &$commentMap[$comment['id']];
                                        } else {
                                            // Handle orphaned comments if necessary
                                            error_log("Orphaned comment found: ID " . $comment['id'] . " with parent_id " . $comment['parent_id']);
                                            // Optionally add orphans to the root level
                                            // $organizedComments[$comment['id']] = &$commentMap[$comment['id']];
                                        }
                                    }
                                }
                                unset($commentMap); // Clean up helper map


                                // Function to recursively display comments
                                if (!function_exists('displayComments')) { // Prevent redeclaration if included elsewhere
                                    function displayComments($commentsArray, $level = 0) {
                                        // Sort comments by creation date if needed (already sorted by query usually)
                                        // uasort($commentsArray, function($a, $b) {
                                        //     return strtotime($a['created_at']) <=> strtotime($b['created_at']);
                                        // });

                                        foreach ($commentsArray as $comment) {
                                            $margin = $level * 25; // Increased margin slightly
                                            ?>
                                            <div class="comment-item mb-3" style="margin-left: <?= $margin ?>px; border-left: <?= $level > 0 ? '2px solid #eee' : 'none' ?>; padding-left: <?= $level > 0 ? '10px' : '0' ?>;">
                                                <div class="comment-header d-flex justify-content-between align-items-center mb-1">
                                                    <small><strong><?= htmlspecialchars($comment['created_by_name']) ?></strong></small>
                                                    <small class="text-muted"><?= date('d M Y H:i', strtotime($comment['created_at'])) ?></small>
                                                </div>
                                                <div class="comment-body bg-light p-2 rounded mb-1">
                                                    <p class="mb-1"><?= nl2br(htmlspecialchars($comment['comment'])) ?></p>
                                                    <button class="btn btn-sm btn-link reply-btn p-0"
                                                            data-comment-id="<?= $comment['id'] ?>">
                                                        Reply
                                                    </button>
                                                </div>
                                                <?php
                                                if (!empty($comment['replies'])) {
                                                    displayComments($comment['replies'], $level + 1);
                                                }
                                                ?>
                                            </div>
                                            <?php
                                        }
                                    }
                                }

                                if(!empty($organizedComments)) {
                                    displayComments($organizedComments);
                                } else {
                                    echo '<p class="text-muted">Belum ada komentar.</p>';
                                }
                                ?>

                                <!-- Comment Form -->
                                <hr>
                                <form action="activity_add_comment.php" method="POST" class="mt-3" id="commentForm">
                                    <input type="hidden" name="source_type" value="activity">
                                    <input type="hidden" name="source_id" value="<?= $id ?>">
                                    <input type="hidden" name="parent_id" id="parentId" value="">
                                    <div id="replyingTo" class="mb-2" style="display: none;">
                                        <small class="text-muted">Membalas: <span id="replyingToName"></span></small>
                                        <button type="button" class="btn-close btn-sm" aria-label="Close" id="cancelReplyBtn"></button>
                                    </div>
                                    <div class="mb-3">
                                        <textarea class="form-control" name="comment" rows="3" placeholder="Tulis komentar..." required></textarea>
                                    </div>
                                    <div class="mb-3">
                                        <label for="comment_type" class="form-label"><small>Tipe Komentar:</small></label>
                                        <select class="form-select form-select-sm" name="comment_type" id="comment_type" required>
                                            <option value="general">Umum</option>
                                            <option value="manajerial">Manajerial</option>
                                            <option value="operator">Operator</option>
                                            <option value="keuangan">Keuangan</option>
                                            <option value="acd">ACD</option>
                                        </select>
                                    </div>
                                    <button type="submit" class="btn btn-primary btn-sm">Kirim Komentar</button>
                                </form>
                            </div> <!-- End Card Body -->
                        </div> <!-- End Card -->
                    </div> <!-- End Right Column -->
                </div> <!-- End Row -->

            </main>
        </div> <!-- End Outer Row -->
    </div> <!-- End Container Fluid -->

    <!-- Add Todo Modal -->
    <div class="modal fade" id="addTodoModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah To-Do</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form action="activity_add_todo.php" method="POST">
                        <input type="hidden" name="activity_id" value="<?= $id ?>">
                        <div class="mb-3">
                            <label class="form-label">Divisi</label>
                            <select class="form-select" name="divisi" required>
                                <option value="Unit">Unit</option>
                                <option value="Operator">Operator</option>
                                <option value="Keuangan">Keuangan</option>
                                <option value="ACD">ACD</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Task</label>
                            <input type="text" class="form-control" name="title" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Keterangan</label>
                            <textarea class="form-control" name="keterangan" rows="2"></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Due Date</label>
                            <input type="date" class="form-control" name="due_date" required>
                        </div>
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Meeting Modal -->
    <div class="modal fade" id="addMeetingModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Notulen Rapat</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form action="activity_add_meeting.php" method="POST">
                        <input type="hidden" name="activity_id" value="<?= $id ?>">
                        <div class="mb-3">
                            <label class="form-label">Tanggal/Jam Rapat</label>
                            <input type="datetime-local" class="form-control" name="meeting_date" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Notulen</label>
                            <textarea class="form-control" name="notes" rows="5" required></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Item Modal -->
    <div class="modal fade" id="addItemModal" tabindex="-1" aria-labelledby="addItemModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addItemModalLabel">Tambah Item Dibutuhkan</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="activity_add_item.php" method="POST">
                        <input type="hidden" name="source_type" value="activity">
                        <input type="hidden" name="source_id" value="<?= $id ?>">
                        
                        <div class="mb-3">
                            <label for="item_name" class="form-label">Nama Item</label>
                            <input type="text" class="form-control" id="item_name" name="item_name" required>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col">
                                <label for="quantity_needed" class="form-label">Jumlah</label>
                                <input type="number" step="any" class="form-control" id="quantity_needed" name="quantity_needed" required min="0">
                            </div>
                            <div class="col">
                                <label for="unit" class="form-label">Unit</label>
                                <input type="text" class="form-control" id="unit" name="unit" placeholder="e.g., pcs, box, kg">
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="item_notes" class="form-label">Keterangan</label>
                            <textarea class="form-control" id="item_notes" name="notes" rows="3"></textarea>
                        </div>
                        
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                            <button type="submit" class="btn btn-primary">Simpan Item</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Ensure this script is placed after the comment section HTML or within DOMContentLoaded
        document.addEventListener('DOMContentLoaded', function() {
            const commentForm = document.getElementById('commentForm');
            const parentIdInput = document.getElementById('parentId');
            const commentTextarea = commentForm.querySelector('textarea[name="comment"]');
            const replyingToDiv = document.getElementById('replyingTo');
            const replyingToNameSpan = document.getElementById('replyingToName');
            const cancelReplyBtn = document.getElementById('cancelReplyBtn');

            // Function to reset the form to top-level comment state
            function resetCommentForm() {
                parentIdInput.value = '';
                commentTextarea.placeholder = 'Tulis komentar...';
                replyingToDiv.style.display = 'none';
                replyingToNameSpan.textContent = '';
            }

            document.querySelectorAll('.reply-btn').forEach(button => {
                button.addEventListener('click', function() {
                    const commentId = this.getAttribute('data-comment-id');
                    const commentItem = this.closest('.comment-item');
                    const authorName = commentItem.querySelector('.comment-header strong').textContent;

                    parentIdInput.value = commentId; // Set the parent_id hidden field
                    commentTextarea.focus(); // Focus the textarea
                    commentTextarea.placeholder = 'Balas komentar kepada ' + authorName + '...'; // Change placeholder

                    // Show replying to info
                    replyingToNameSpan.textContent = authorName;
                    replyingToDiv.style.display = 'block';

                    console.log('Replying to comment ID:', commentId, 'by', authorName); // Debugging
                });
            });

            // Cancel reply button functionality
            cancelReplyBtn.addEventListener('click', function() {
                resetCommentForm();
            });

            // Optional: Reset if user clears textarea and focuses away/submits
            commentTextarea.addEventListener('blur', function() {
                 if (this.value === '' && parentIdInput.value !== '') {
                     // Maybe don't reset on blur, only on cancel or submit
                 }
            });

             // Reset form state on successful submission (requires AJAX or page reload observation)
             // If using standard form submission, the page reloads anyway.
             // If using AJAX, call resetCommentForm() in the success handler.
        });
    </script>
</body>
</html>
