<?php
require_once 'includes/config.php';
// require_once 'includes/auth.php'; // Uncomment if authentication is needed

$page_title = "Pengaturan Tanggal Libur Nasional";
$success_messages = [];
$error_messages = [];

// --- Handle Form Submission (Add Holiday Range) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_holiday'])) {
    $start_date_str = trim($_POST['start_date']);
    $end_date_str = trim($_POST['end_date']);
    $description = trim($_POST['description']);

    // Default end date to start date if empty
    if (empty($end_date_str)) {
        $end_date_str = $start_date_str;
    }

    if (!empty($start_date_str) && !empty($end_date_str) && !empty($description)) {
        try {
            // Validate and create DateTime objects just for validation
            $start_date_obj = new DateTime($start_date_str);
            $end_date_obj = new DateTime($end_date_str);

            // Ensure end date is not before start date
            if ($end_date_obj < $start_date_obj) {
                 $error_messages[] = "Tanggal Akhir tidak boleh sebelum Tanggal Awal.";
            } else {
                // {{ Simplified Insertion: Insert the range directly }}
                // NOTE: This version does NOT check for overlapping ranges.
                // Add overlap checks here if required. Example check commented out below.
                /*
                // Example Overlap Check (Optional - uncomment and adapt if needed)
                $overlap_stmt = $conn->prepare(
                    "SELECT id FROM national_holidays
                     WHERE description = ?
                       AND start_date <= ?
                       AND end_date >= ?"
                );
                $overlap_stmt->bind_param("sss", $description, $end_date_str, $start_date_str);
                $overlap_stmt->execute();
                $overlap_result = $overlap_stmt->get_result();
                if ($overlap_result->num_rows > 0) {
                    $error_messages[] = "Rentang tanggal yang dimasukkan tumpang tindih dengan entri yang ada untuk deskripsi yang sama.";
                    $overlap_stmt->close();
                } else {
                    $overlap_stmt->close();
                    // Proceed with insertion if no overlap
                */

                    $insert_stmt = $conn->prepare("INSERT INTO national_holidays (start_date, end_date, description) VALUES (?, ?, ?)");
                    $insert_stmt->bind_param("sss", $start_date_str, $end_date_str, $description);

                    if ($insert_stmt->execute()) {
                        $success_messages[] = "Rentang tanggal libur '" . htmlspecialchars($description) . "' (" . $start_date_obj->format('d M Y') . " - " . $end_date_obj->format('d M Y') . ") berhasil ditambahkan.";
                    } else {
                        $error_messages[] = "Gagal menambahkan rentang tanggal libur: " . $insert_stmt->error;
                    }
                    $insert_stmt->close();
                /*
                } // End else block for overlap check
                */
            }

        } catch (Exception $e) {
            $error_messages[] = "Format Tanggal Awal atau Tanggal Akhir tidak valid. Gunakan format YYYY-MM-DD.";
        }

    } else {
        $error_messages[] = "Tanggal Awal, Deskripsi tidak boleh kosong. Tanggal Akhir opsional (default sama dengan Tanggal Awal).";
    }
}

// --- Handle Deletion ---
// {{ Modify deletion logic to use ID }}
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_holiday_id'])) { // Changed trigger name and parameter
    $holiday_id_to_delete = filter_input(INPUT_POST, 'delete_holiday_id', FILTER_VALIDATE_INT);

    if ($holiday_id_to_delete) {
        $delete_stmt = $conn->prepare("DELETE FROM national_holidays WHERE id = ?");
        $delete_stmt->bind_param("i", $holiday_id_to_delete);

        if ($delete_stmt->execute()) {
            if ($delete_stmt->affected_rows > 0) {
                 $success_messages[] = "Entri tanggal libur berhasil dihapus.";
            } else {
                 $error_messages[] = "Tidak ada entri tanggal libur yang cocok ditemukan untuk dihapus (ID: $holiday_id_to_delete).";
            }
        } else {
            $error_messages[] = "Gagal menghapus entri tanggal libur: " . $delete_stmt->error;
        }
        $delete_stmt->close();
    } else {
         $error_messages[] = "ID tidak valid untuk menghapus entri.";
    }
}


// --- Fetch Existing Holidays ---
// {{ Simplified Fetching: No grouping needed }}
$current_year = date('Y');
// Fetch ranges that start in or after the current year OR end in or after the current year
// Order by start date
$holidays_result = $conn->query(
    "SELECT id, start_date, end_date, description
     FROM national_holidays
     WHERE YEAR(end_date) >= $current_year
     ORDER BY start_date ASC, end_date ASC"
);

// {{ Remove the complex grouping logic }}
// $grouped_holidays = []; // No longer needed
// ... remove the while loop that created $grouped_holidays ...

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($page_title) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
    <link href="../assets/css/dashboard.css" rel="stylesheet">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>

            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-3">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
                    <h1 class="h4"><?= htmlspecialchars($page_title) ?></h1>
                </div>

                
                <?php if (!empty($success_messages)): ?>
                    <?php foreach ($success_messages as $msg): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?= htmlspecialchars($msg) ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
                <?php if (!empty($error_messages)): ?>
                     <?php foreach ($error_messages as $msg): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <?= htmlspecialchars($msg) ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>


                <!-- Add Holiday Form -->
                {{-- Add form remains the same --}}
                <div class="card mb-4">
                    <div class="card-header">
                        <h5>Tambah Rentang Tanggal Libur Baru</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="activity_holidays.php">
                            <div class="row g-3 align-items-end">
                                
                                <div class="col-md-3">
                                    <label for="start_date" class="form-label">Tanggal Awal</label>
                                    <input type="date" class="form-control" id="start_date" name="start_date" required>
                                </div>
                                <div class="col-md-3">
                                    <label for="end_date" class="form-label">Tanggal Akhir</label>
                                    <input type="date" class="form-control" id="end_date" name="end_date" aria-describedby="endDateHelp">
                                    
                                </div>
                                
                                <div class="col-md-4">
                                    <label for="description" class="form-label">Deskripsi</label>
                                    <input type="text" class="form-control" id="description" name="description" placeholder="Contoh: Libur Lebaran" required>
                                </div>
                                <div class="col-md-2">
                                    <button type="submit" name="add_holiday" class="btn btn-primary w-100">Tambah</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>


                <!-- Holiday List -->
                <div class="card">
                     <div class="card-header">
                        <h5>Daftar Tanggal Libur (Berakhir Mulai Tahun <?= $current_year ?>)</h5> {{-- Adjusted title slightly --}}
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>Rentang Tanggal</th>
                                        <th>Deskripsi</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {{# Iterate directly through the query result #}}
                                    <?php if ($holidays_result && $holidays_result->num_rows > 0): ?>
                                        <?php while($holiday = $holidays_result->fetch_assoc()): ?>
                                        <?php
                                            // Format dates directly from the row
                                            $start_date_obj = new DateTime($holiday['start_date']);
                                            $end_date_obj = new DateTime($holiday['end_date']);
                                            $start_date_formatted = $start_date_obj->format('d M Y');
                                            $end_date_formatted = $end_date_obj->format('d M Y');

                                            $display_date = $start_date_formatted;
                                            // Display range only if start and end dates are different
                                            if ($start_date_formatted !== $end_date_formatted) {
                                                $display_date .= ' - ' . $end_date_formatted;
                                            }
                                        ?>
                                        <tr>
                                            <td><?= $display_date ?></td>
                                            <td><?= htmlspecialchars($holiday['description']) ?></td>
                                            <td>
                                                {{# Update the delete form to send the row ID #}}
                                                <form method="POST" action="activity_holidays.php" onsubmit="return confirm('Apakah Anda yakin ingin menghapus entri libur ini?');" style="display: inline;">
                                                    <input type="hidden" name="delete_holiday_id" value="<?= $holiday['id'] ?>"> {{-- Send ID --}}
                                                    <button type="submit" class="btn btn-sm btn-danger" title="Hapus Entri"> {{-- Changed title --}}
                                                        <i class="fas fa-trash-alt"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                        <?php endwhile; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="3" class="text-center">Belum ada data tanggal libur untuk tahun ini atau mendatang.</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const startDateInput = document.getElementById('start_date');
            const endDateInput = document.getElementById('end_date');

            if (startDateInput && endDateInput) {
                startDateInput.addEventListener('change', function() {
                    // If end date is empty or earlier than start date, set it to start date
                    if (!endDateInput.value || endDateInput.value < startDateInput.value) {
                        endDateInput.value = startDateInput.value;
                    }
                    // Also set the minimum allowed value for the end date
                    endDateInput.min = startDateInput.value;
                });

                 // Initial check in case the start date is pre-filled (e.g., browser remembers)
                 if (startDateInput.value) {
                     endDateInput.min = startDateInput.value;
                     if (!endDateInput.value || endDateInput.value < startDateInput.value) {
                         // Optionally set it on load too, or just enforce the min attribute
                         // endDateInput.value = startDateInput.value;
                     }
                 }
            }
        });
    </script>
</body>
</html>