<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';

$id = $_GET['id'] ?? null;
if (!$id) {
    header("Location: activities.php");
    exit();
}

$todos = $conn->query("SELECT * FROM activity_todos WHERE activity_id = $id ORDER BY due_date");
?>

<!DOCTYPE html>
<html>
<head>
    <title>Activity To-Do List</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-3">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
                    <h1 class="h2">Activity To-Do List</h1>
                </div>

                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Divisi</th>
                                <th>Task</th>
                                <th>Keterangan</th>
                                <th>Due Date</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($todo = $todos->fetch_assoc()): ?>
                            <tr>
                                <td><?= htmlspecialchars($todo['divisi']) ?></td>
                                <td><?= htmlspecialchars($todo['title']) ?></td>
                                <td><?= htmlspecialchars($todo['keterangan']) ?></td>
                                <td><?= date('d M Y', strtotime($todo['due_date'])) ?></td>
                                <td><?= ucfirst($todo['status']) ?></td>
                                <td>
                                    <a href="activity_edit_todo.php?id=<?= $todo['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </main>
        </div>
    </div>
</body>
</html>