<?php
require_once 'includes/config.php';
// Optional: Add authentication check if needed
// require_once 'includes/auth.php'; 

// Allowed statuses (sync with your ENUM definition)
$allowed_statuses = ['pending', 'ordered', 'received', 'cancelled'];

// Check if the form was submitted via POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // --- Data Retrieval ---
    $item_id = isset($_POST['item_id']) ? (int)$_POST['item_id'] : null;
    $next_status = $_POST['next_status'] ?? null;
    $source_id = isset($_POST['source_id']) ? (int)$_POST['source_id'] : null; // For redirecting back

    // --- Basic Validation ---
    if (empty($item_id) || empty($next_status) || empty($source_id) || !in_array($next_status, $allowed_statuses)) {
        error_log("Invalid item status toggle request. Item ID: {$item_id}, Next Status: {$next_status}, Source ID: {$source_id}");
        // Redirect back with an error message (using session flash messages is better)
        header("Location: activity_detail.php?id=" . $source_id . "&error=invalid_toggle");
        exit();
    }

    // --- Database Update ---
    // Prepare SQL statement to prevent SQL injection
    $sql = "UPDATE unified_item_list SET status = ?, updated_at = CURRENT_TIMESTAMP WHERE id = ?";
    $stmt = $conn->prepare($sql);

    if ($stmt) {
        // Bind parameters (s = string, i = integer)
        $stmt->bind_param("si", $next_status, $item_id);

        // Execute the statement
        if ($stmt->execute()) {
            // Success: Redirect back to the activity detail page
            header("Location: activity_detail.php?id=" . $source_id);
            exit();
        } else {
            // Error during execution
            error_log("Error executing item status update statement: " . $stmt->error);
            // Redirect back with an error message
            header("Location: activity_detail.php?id=" . $source_id . "&error=update_failed");
            exit();
        }
        // Close statement
        $stmt->close();
    } else {
        // Error preparing statement
        error_log("Error preparing item status update statement: " . $conn->error);
        // Redirect back with an error message
        header("Location: activity_detail.php?id=" . $source_id . "&error=prepare_failed");
        exit();
    }

    // Close connection (optional)
    // $conn->close();

} else {
    // If not a POST request, redirect to a safe page
    header("Location: activities.php");
    exit();
}
?>