<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $source_type = $_POST['source_type'];
    $source_id = (int)$_POST['source_id'];
    $comment = trim($_POST['comment']);
    $type = $_POST['comment_type'];
    $username = $_SESSION['username'];
    
    // Handle file upload
    $attachment = null;
    if (!empty($_FILES['attachment']['name'])) {
        $uploadDir = '../uploads/comments/';
        $fileName = time() . '_' . basename($_FILES['attachment']['name']);
        $targetPath = $uploadDir . $fileName;
        
        if (move_uploaded_file($_FILES['attachment']['tmp_name'], $targetPath)) {
            $attachment = $fileName;
        }
    }
    
    $stmt = $conn->prepare("
        INSERT INTO unified_comments 
        (source_type, source_id, comment, type, created_by, attachment)
        VALUES (?, ?, ?, ?, ?, ?)
    ");
    $stmt->bind_param("sissis", $source_type, $source_id, $comment, $type, $username, $attachment);
    
    if ($stmt->execute()) {
        header("Location: {$_SERVER['HTTP_REFERER']}");
        exit();
    } else {
        die("Error: " . $conn->error);
    }
}
?>