<?php
require_once 'includes/config.php'; // Include your database connection

// --- User Details ---
$username = 'admin';
$plain_password = 'admin'; // The password to be hashed
$name = 'Administrator'; // Default name
$email = 'admin@example.com'; // Placeholder email
$role = 'admin'; // User role

// --- Hash the password ---
// Use PASSWORD_DEFAULT for the best available hashing algorithm
$hashed_password = password_hash($plain_password, PASSWORD_DEFAULT);

if ($hashed_password === false) {
    die("Error: Failed to hash the password.");
}

echo "Attempting to create user: $username<br>";
echo "Hashed password: $hashed_password<br>"; // Displaying hash for confirmation (remove in production)

// --- Check if user already exists ---
try {
    $stmt_check = $conn->prepare("SELECT id FROM users WHERE username = ? OR email = ?");
    if (!$stmt_check) {
        throw new Exception("Prepare failed (check): (" . $conn->errno . ") " . $conn->error);
    }
    $stmt_check->bind_param("ss", $username, $email);
    $stmt_check->execute();
    $result_check = $stmt_check->get_result();

    if ($result_check->num_rows > 0) {
        echo "Error: User with username '$username' or email '$email' already exists.<br>";
        $stmt_check->close();
    } else {
        $stmt_check->close();
        echo "User does not exist, proceeding with insertion...<br>";

        // --- Prepare SQL Insert Statement ---
        $sql = "INSERT INTO users (username, password, name, email, role, created_at) VALUES (?, ?, ?, ?, ?, NOW())";
        $stmt = $conn->prepare($sql);

        if (!$stmt) {
            throw new Exception("Prepare failed (insert): (" . $conn->errno . ") " . $conn->error);
        }

        // --- Bind Parameters ---
        // s = string
        $stmt->bind_param("sssss",
            $username,
            $hashed_password,
            $name,
            $email,
            $role
        );

        // --- Execute Statement ---
        if ($stmt->execute()) {
            echo "Success: Admin user '$username' created successfully!<br>";
        } else {
            throw new Exception("Execute failed (insert): (" . $stmt->errno . ") " . $stmt->error);
        }

        $stmt->close();
    }

} catch (Exception $e) {
    echo "Error: Failed to create admin user. " . $e->getMessage() . "<br>";
    // Log detailed error
    error_log("Error creating admin user '$username': " . $e->getMessage());
}

// Close the connection (optional, often handled by PHP ending script)
// $conn->close();

echo "Script finished.";
?>