<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';

// Query to get facilities data
$facilities = $conn->query("SELECT * FROM facilities ORDER BY name");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar Fasilitas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Daftar Fasilitas</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <a href="fasilitas_tambah.php" class="btn btn-sm btn-outline-primary">
                            <i class="bi bi-plus"></i> Tambah Fasilitas
                        </a>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Nama Fasilitas</th>
                                <th>Lokasi</th>
                                <th>Status</th>
                                <th>Terakhir Diperbarui</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($facility = $facilities->fetch_assoc()): ?>
                            <tr>
                                <td><?= htmlspecialchars($facility['name']) ?></td>
                                <td><?= htmlspecialchars($facility['location']) ?></td>
                                <td>
                                    <span class="badge <?= $facility['status'] == 'active' ? 'bg-success' : 'bg-secondary' ?>">
                                        <?= ucfirst($facility['status']) ?>
                                    </span>
                                </td>
                                <td><?= date('d M Y', strtotime($facility['updated_at'])) ?></td>
                                <td>
                                    <a href="fasilitas_edit.php?id=<?= $facility['id'] ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                                    <a href="fasilitas_hapus.php?id=<?= $facility['id'] ?>" class="btn btn-sm btn-outline-danger">Hapus</a>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </main>
        </div>
    </div>

    <?php include 'includes/footer.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>