<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';

// Query to get maintenance records
$maintenance = $conn->query("
    SELECT m.*, f.name as facility_name 
    FROM facility_maintenance m
    JOIN facilities f ON m.facility_id = f.id
    ORDER BY m.maintenance_date DESC
");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pemeliharaan Fasilitas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Pemeliharaan Fasilitas</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <a href="fasilitas_pemeliharaan_tambah.php" class="btn btn-sm btn-outline-primary">
                            <i class="bi bi-plus"></i> Tambah Pemeliharaan
                        </a>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Nama Fasilitas</th>
                                <th>Tanggal Pemeliharaan</th>
                                <th>Deskripsi</th>
                                <th>Status</th>
                                <th>Biaya</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($record = $maintenance->fetch_assoc()): ?>
                            <tr>
                                <td><?= htmlspecialchars($record['facility_name']) ?></td>
                                <td><?= date('d M Y', strtotime($record['maintenance_date'])) ?></td>
                                <td><?= htmlspecialchars($record['description']) ?></td>
                                <td>
                                    <span class="badge <?= $record['status'] == 'completed' ? 'bg-success' : 'bg-warning' ?>">
                                        <?= ucfirst($record['status']) ?>
                                    </span>
                                </td>
                                <td><?= number_format($record['cost'], 0, ',', '.') ?></td>
                                <td>
                                    <a href="fasilitas_pemeliharaan_edit.php?id=<?= $record['id'] ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                                    <a href="fasilitas_pemeliharaan_hapus.php?id=<?= $record['id'] ?>" class="btn btn-sm btn-outline-danger">Hapus</a>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </main>
        </div>
    </div>

    <?php include 'includes/footer.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>