<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';

if (!isset($_GET['id'])) {
    header("Location: fasilitas_pemeliharaan.php");
    exit();
}

$id = $_GET['id'];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $facility_id = $_POST['facility_id'];
    $maintenance_date = $_POST['maintenance_date'];
    $description = $_POST['description'];
    $status = $_POST['status'];
    $cost = $_POST['cost'];

    $stmt = $conn->prepare("UPDATE facility_maintenance 
                          SET facility_id = ?, maintenance_date = ?, description = ?, 
                              status = ?, cost = ?
                          WHERE id = ?");
    $stmt->bind_param("isssdi", $facility_id, $maintenance_date, $description, $status, $cost, $id);
    
    if ($stmt->execute()) {
        header("Location: fasilitas_pemeliharaan.php?success=1");
        exit();
    } else {
        $error = "Failed to update maintenance record";
    }
}

// Get current maintenance record
$maintenance = $conn->query("
    SELECT m.*, f.name as facility_name 
    FROM facility_maintenance m
    JOIN facilities f ON m.facility_id = f.id
    WHERE m.id = $id
")->fetch_assoc();

if (!$maintenance) {
    header("Location: fasilitas_pemeliharaan.php");
    exit();
}

// Get all facilities for dropdown
$facilities = $conn->query("SELECT id, name FROM facilities ORDER BY name");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Pemeliharaan Fasilitas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Edit Pemeliharaan Fasilitas</h1>
                </div>

                <?php if (isset($error)): ?>
                <div class="alert alert-danger"><?= $error ?></div>
                <?php endif; ?>

                <form method="POST">
                    <div class="mb-3">
                        <label for="facility_id" class="form-label">Fasilitas</label>
                        <select class="form-select" id="facility_id" name="facility_id" required>
                            <?php while($facility = $facilities->fetch_assoc()): ?>
                            <option value="<?= $facility['id'] ?>" 
                                <?= $facility['id'] == $maintenance['facility_id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($facility['name']) ?>
                            </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="maintenance_date" class="form-label">Tanggal Pemeliharaan</label>
                        <input type="date" class="form-control" id="maintenance_date" name="maintenance_date" 
                               value="<?= $maintenance['maintenance_date'] ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">Deskripsi</label>
                        <textarea class="form-control" id="description" name="description" rows="3" required><?= 
                            htmlspecialchars($maintenance['description']) ?></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="status" class="form-label">Status</label>
                        <select class="form-select" id="status" name="status" required>
                            <option value="scheduled" <?= $maintenance['status'] == 'scheduled' ? 'selected' : '' ?>>Scheduled</option>
                            <option value="in_progress" <?= $maintenance['status'] == 'in_progress' ? 'selected' : '' ?>>In Progress</option>
                            <option value="completed" <?= $maintenance['status'] == 'completed' ? 'selected' : '' ?>>Completed</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="cost" class="form-label">Biaya (Rp)</label>
                        <input type="number" class="form-control" id="cost" name="cost" step="0.01" min="0"
                               value="<?= $maintenance['cost'] ?>">
                    </div>
                    <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                    <a href="fasilitas_pemeliharaan.php" class="btn btn-secondary">Batal</a>
                </form>
            </main>
        </div>
    </div>

    <?php include 'includes/footer.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>