<?php
require_once 'includes/config.php';
//require_once 'includes/auth.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $date = $_POST['date'];
    $focus_type = $_POST['focus_type'];
    $spotlight = $_POST['spotlight'];
    $due_date = $_POST['due_date'];
    $notes = $_POST['notes'];

    $stmt = $conn->prepare("INSERT INTO focuses (name, date, focus_type, spotlight, due_date, notes) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssss", $name, $date, $focus_type, $spotlight, $due_date, $notes);
    $stmt->execute();
    $stmt->close();

    header("Location: focus.php?success=1");
    exit();
}

$focuses = $conn->query("SELECT * FROM focuses ORDER BY date DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manajemen Fokus</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-3">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
                    <h1 class="h2">Data Fokus</h1>
                </div>

                <?php if (isset($_GET['success'])): ?>
                <div class="alert alert-success">Data fokus berhasil disimpan!</div>
                <?php endif; ?>

                <!-- Add Focus Form -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5>Tambah Fokus Baru</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST">
                            <div class="mb-3">
                                <label class="form-label">Nama Fokus</label>
                                <input type="text" class="form-control" name="name" required>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Tanggal</label>
                                        <input type="date" class="form-control" name="date" value="<?= date('Y-m-d') ?>" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Jenis Fokus</label>
                                        <select class="form-select" name="focus_type" required>
                                            <option value="Yayasan">Yayasan</option>
                                            <option value="Manajerial">Manajerial</option>
                                            <option value="HRD">HRD</option>
                                            <option value="Unit">Unit</option>
                                            <option value="Keuangan">Keuangan</option>
                                            <option value="Lainnya">Lainnya</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Spotlight</label>
                                        <select class="form-select" name="spotlight" required>
                                            <option value="Pengawasan Khusus">Pengawasan Khusus</option>
                                            <option value="Pengawasan Cukup">Pengawasan Cukup</option>
                                            <option value="Normal" selected>Normal</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Due Date</label>
                                        <input type="date" class="form-control" name="due_date">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Catatan</label>
                                <textarea class="form-control" name="notes" rows="3"></textarea>
                            </div>
                            
                            <button type="submit" class="btn btn-primary">Simpan</button>
                        </form>
                    </div>
                </div>

                <!-- Focus List -->
                <div class="card">
                    <div class="card-header">
                        <h5>Daftar Fokus</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Tanggal</th>
                                        <th>Nama</th>
                                        <th>Jenis</th>
                                        <th>Spotlight</th>
                                        <th>Due Date</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while($focus = $focuses->fetch_assoc()): ?>
                                    <tr>
                                        <td><?= date('d M Y', strtotime($focus['date'])) ?></td>
                                        <td><?= htmlspecialchars($focus['name']) ?></td>
                                        <td><?= htmlspecialchars($focus['focus_type']) ?></td>
                                        <td><?= htmlspecialchars($focus['spotlight']) ?></td>
                                        <td><?= $focus['due_date'] ? date('d M Y', strtotime($focus['due_date'])) : '-' ?></td>
                                        <td>
                                            <a href="focus_detail.php?id=<?= $focus['id'] ?>" class="btn btn-sm btn-info">Detail</a>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>