<?php
require_once 'includes/config.php';
//require_once 'includes/auth.php';

$id = $_GET['id'] ?? null;
if (!$id) {
    header("Location: focus.php");
    exit();
}

// Get focus details
$focus = $conn->query("SELECT * FROM focuses WHERE id = $id")->fetch_assoc();
if (!$focus) {
    header("Location: focus.php");
    exit();
}

// Get todos for this focus
$todos = $conn->query("SELECT * FROM focus_todos WHERE focus_id = $id ORDER BY due_date");

// Get meetings for this focus
$meetings = $conn->query("SELECT * FROM focus_meetings WHERE focus_id = $id ORDER BY meeting_date DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Detail Fokus</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-3">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
                    <h1 class="h2">Data Fokus: <?= htmlspecialchars($focus['name']) ?></h1>
                    <div class="btn-group">
                        <a href="focus.php" class="btn btn-sm btn-outline-secondary">Daftar Fokus</a>
                        <a href="focus_detail.php?id=<?= $id ?>" class="btn btn-sm btn-outline-secondary active">Detail Fokus</a>
                        <a href="focus_todos.php" class="btn btn-sm btn-outline-secondary">To-Do List</a>
                        <a href="focus_meetings.php" class="btn btn-sm btn-outline-secondary">Notulen Rapat</a>
                    </div>
                </div>

                <!-- Basic Info Section -->
                <div class="card mb-4">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <p><strong>Tanggal:</strong> <?= date('d M Y', strtotime($focus['date'])) ?></p>
                                <p><strong>Jenis:</strong> <?= htmlspecialchars($focus['focus_type']) ?></p>
                            </div>
                            <div class="col-md-6">
                                <p><strong>Status:</strong> <?= htmlspecialchars($focus['spotlight']) ?></p>
                                <p><strong>Due Date:</strong> <?= $focus['due_date'] ? date('d M Y', strtotime($focus['due_date'])) : '-' ?></p>
                            </div>
                        </div>
                        <p><strong>Catatan:</strong><br><?= nl2br(htmlspecialchars($focus['notes'])) ?></p>
                    </div>
                </div>

                <!-- To-Do List Section -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5>To-Do List</h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Task</th>
                                    <th>Due Date</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php while($todo = $todos->fetch_assoc()): ?>
                                <tr>
                                    <td><?= htmlspecialchars($todo['title']) ?></td>
                                    <td><?= date('d M Y', strtotime($todo['due_date'])) ?></td>
                                    <td><?= ucfirst($todo['status']) ?></td>
                                </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addTodoModal">
                            Tambah To-Do
                        </button>
                    </div>
                </div>

                <!-- Meeting Notes Section -->
                <div class="card">
                    <div class="card-header">
                        <h5>Notulen Rapat</h5>
                    </div>
                    <div class="card-body">
                        <div class="list-group">
                            <?php while($meeting = $meetings->fetch_assoc()): ?>
                            <div class="list-group-item">
                                <h6>Rapat <?= date('d M Y H:i', strtotime($meeting['meeting_date'])) ?></h6>
                                <p><?= nl2br(htmlspecialchars($meeting['notes'])) ?></p>
                            </div>
                            <?php endwhile; ?>
                        </div>
                        <button class="btn btn-primary mt-3" data-bs-toggle="modal" data-bs-target="#addMeetingModal">
                            Tambah Notulen
                        </button>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <!-- Add Todo Modal -->
    <div class="modal fade" id="addTodoModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah To-Do</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form action="focus_add_todo.php" method="POST">
                        <input type="hidden" name="focus_id" value="<?= $id ?>">
                        <div class="mb-3">
                            <label class="form-label">Task</label>
                            <input type="text" class="form-control" name="title" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Due Date</label>
                            <input type="date" class="form-control" name="due_date" required>
                        </div>
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Meeting Modal -->
    <div class="modal fade" id="addMeetingModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Notulen Rapat</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form action="focus_add_meeting.php" method="POST">
                        <input type="hidden" name="focus_id" value="<?= $id ?>">
                        <div class="mb-3">
                            <label class="form-label">Tanggal/Jam Rapat</label>
                            <input type="datetime-local" class="form-control" name="meeting_date" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Notulen</label>
                            <textarea class="form-control" name="notes" rows="5" required></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>