<?php
$card_class = '';
if($activity['spotlight'] == 'Pengawasan Khusus') {
    $card_class = 'border-danger';
} elseif($activity['spotlight'] == 'Pengawasan Cukup') {
    $card_class = 'border-warning';
} else {
    $card_class = 'border-primary';
}

// Get todo counts from unified_todos with strict source matching
$todo_query = $conn->query("SELECT 
    COUNT(*) as todo_count,
    SUM(CASE WHEN status = 'completed' THEN 1 ELSE 0 END) as completed_count
    FROM unified_todos 
    WHERE source_type = 'activity' AND source_id = {$activity['id']}");
    // Removed deleted_at condition since column doesn't exist

if (!$todo_query) {
    error_log("Todo query failed: " . $conn->error); // Log errors for debugging
    $todo_data = ['todo_count' => 0, 'completed_count' => 0];
} else {
    $todo_data = $todo_query->fetch_assoc();
    if (!$todo_data) {
        $todo_data = ['todo_count' => 0, 'completed_count' => 0];
    }
}

// Debug output (remove in production)
// error_log(print_r($todo_data, true));

$success_percentage = 0;
if (!empty($todo_data['todo_count']) && $todo_data['todo_count'] > 0) {
    $success_percentage = round(($todo_data['completed_count'] / $todo_data['todo_count']) * 100);
}
?>
<div class="col-12 mb-3">
    <div class="card <?= $card_class ?> h-100">
        <div class="card-body d-flex flex-column">
            <h5 class="card-title"><?= htmlspecialchars($activity['name']) ?></h5>
            <div class="mb-2">
                <span class="badge bg-secondary me-1"><?= htmlspecialchars($activity['person_in_charge']) ?></span>
                <span class="badge <?= $activity['spotlight'] == 'Pengawasan Khusus' ? 'bg-danger' : 
                                    ($activity['spotlight'] == 'Pengawasan Cukup' ? 'bg-warning' : 'bg-primary') ?>">
                    <?= htmlspecialchars($activity['spotlight']) ?>
                </span>
            </div>
            
            <!-- Progress bar -->
            <div class="progress mt-2 mb-2" style="height: 20px;">
                <div class="progress-bar <?= $success_percentage == 100 ? 'bg-success' : 'bg-info' ?>" 
                     role="progressbar" 
                     style="width: <?= $success_percentage ?>%" 
                     aria-valuenow="<?= $success_percentage ?>" 
                     aria-valuemin="0" 
                     aria-valuemax="100">
                    <?= $success_percentage ?>%
                </div>
            </div>
            
            <div class="mt-auto">
                <div class="d-flex justify-content-between align-items-center">
                    <small class="text-muted"><?= date('d M Y', strtotime($activity['date'])) ?></small>
                    <a href="activity_detail.php?id=<?= $activity['id'] ?>" 
                       class="btn btn-sm btn-outline-primary">Detail</a>
                </div>
            </div>
        </div>
    </div>
</div>