<?php
$card_class = '';
if($procurement['spotlight'] == 'Pengawasan Khusus') {
    $card_class = 'border-danger';
} elseif($procurement['spotlight'] == 'Pengawasan Umum') {
    $card_class = 'border-warning';
} else {
    $card_class = 'border-primary';
}

// Get todo counts from unified_todos
$todo_query = $conn->query("SELECT 
    COUNT(*) as todo_count,
    SUM(CASE WHEN status = 'completed' THEN 1 ELSE 0 END) as completed_count
    FROM unified_todos 
    WHERE source_type = 'procurement' AND source_id = {$procurement['id']}");
    
if (!$todo_query) {
    $todo_data = ['todo_count' => 0, 'completed_count' => 0];
} else {
    $todo_data = $todo_query->fetch_assoc();
    if (!$todo_data) {
        $todo_data = ['todo_count' => 0, 'completed_count' => 0];
    }
}

$success_percentage = 0;
if (isset($todo_data['todo_count']) && $todo_data['todo_count'] > 0) {
    $success_percentage = round(($todo_data['completed_count'] / $todo_data['todo_count']) * 100);
}
?>
<div class="col-12 mb-3">
    <div class="card <?= $card_class ?> h-100">
        <div class="card-body d-flex flex-column">
            <h5 class="card-title"><?= htmlspecialchars($procurement['name']) ?></h5>
            <div class="mb-2">
                <span class="badge bg-secondary me-1"><?= htmlspecialchars($procurement['procurement_type']) ?></span>
                <span class="badge <?= $procurement['spotlight'] == 'Pengawasan Khusus' ? 'bg-danger' : 
                                    ($procurement['spotlight'] == 'Pengawasan Umum' ? 'bg-warning' : 'bg-primary') ?>">
                    <?= htmlspecialchars($procurement['spotlight']) ?>
                </span>
            </div>
            
            <!-- Progress bar -->
            <div class="progress mt-2 mb-2" style="height: 20px;">
                <div class="progress-bar <?= $success_percentage == 100 ? 'bg-success' : 'bg-info' ?>" 
                     role="progressbar" 
                     style="width: <?= $success_percentage ?>%" 
                     aria-valuenow="<?= $success_percentage ?>" 
                     aria-valuemin="0" 
                     aria-valuemax="100">
                    <?= $success_percentage ?>%
                </div>
            </div>
            
            <div class="mt-auto">
                <div class="d-flex justify-content-between align-items-center">
                    <small class="text-muted"><?= date('d M Y', strtotime($procurement['date'])) ?></small>
                    <a href="procurement_detail.php?id=<?= $procurement['id'] ?>" 
                       class="btn btn-sm btn-outline-primary">Detail</a>
                </div>
            </div>
        </div>
    </div>
</div>