<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['excel_file'])) {
    try {
        // Simple CSV parsing for Excel files
        $file = $_FILES['excel_file']['tmp_name'];
        
        // Convert Excel to temporary CSV
        $csvFile = tempnam(sys_get_temp_dir(), 'csv');
        shell_exec("c:\xampp\htdocs\manajemen\admin\libreoffice\program\soffice.exe --headless --convert-to csv $file --outdir " . dirname($csvFile));
        $csvFile .= '.csv';
        
        if (!file_exists($csvFile)) {
            throw new Exception("Gagal mengkonversi file Excel ke format CSV");
        }
        
        // Read CSV file
        $handle = fopen($csvFile, 'r');
        if ($handle === false) {
            throw new Exception("Gagal membuka file CSV");
        }
        
        // Validate header
        $headers = fgetcsv($handle);
        if (strtolower($headers[0]) != 'tanggal' || 
            strtolower($headers[1]) != 'kategori' || 
            strtolower($headers[2]) != 'jumlah' || 
            strtolower($headers[3]) != 'keterangan') {
            throw new Exception("Format file tidak valid. Pastikan kolom header sesuai: Tanggal, Kategori, Jumlah, Keterangan");
        }
        
        // Prepare database transaction
        $conn->begin_transaction();
        
        // Process each row
        while (($data = fgetcsv($handle)) !== false) {
            $tanggal = $data[0];
            $kategori = $data[1];
            $jumlah = $data[2];
            $keterangan = $data[3];
            
            // Insert into database
            $stmt = $conn->prepare("INSERT INTO keuangan (tanggal, kategori, jumlah, keterangan) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("ssds", $tanggal, $kategori, $jumlah, $keterangan);
            $stmt->execute();
            $stmt->close();
        }
        
        fclose($handle);
        unlink($csvFile);
        
        $conn->commit();
        $_SESSION['success'] = "Data keuangan berhasil diupload dan diproses!";
        
    } catch (Exception $e) {
        $conn->rollback();
        $_SESSION['error'] = "Error: " . $e->getMessage();
    }
    
    header("Location: keuangan_upload.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Upload Data Keuangan Bulanan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-3">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
                    <h1 class="h2">Upload Data Keuangan Bulanan</h1>
                </div>

                <!-- Success/Error Messages -->
                <?php if (isset($_SESSION['success'])): ?>
                    <div class="alert alert-success"><?= $_SESSION['success'] ?></div>
                    <?php unset($_SESSION['success']); ?>
                <?php endif; ?>
                
                <?php if (isset($_SESSION['error'])): ?>
                    <div class="alert alert-danger"><?= $_SESSION['error'] ?></div>
                    <?php unset($_SESSION['error']); ?>
                <?php endif; ?>

                <!-- Upload Form -->
                <div class="card">
                    <div class="card-body">
                        <form method="POST" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label class="form-label">Pilih File Excel (.xls, .xlsx)</label>
                                <input type="file" class="form-control" name="excel_file" accept=".xls,.xlsx" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Format File:</label>
                                <ul>
                                    <li>Kolom A: Tanggal (YYYY-MM-DD)</li>
                                    <li>Kolom B: Kategori</li>
                                    <li>Kolom C: Jumlah (angka)</li>
                                    <li>Kolom D: Keterangan</li>
                                </ul>
                            </div>
                            <button type="submit" class="btn btn-primary">Upload & Proses</button>
                        </form>
                    </div>
                </div>
            </main>
        </div>
    </div>
</body>
</html>