<?php
require_once 'includes/config.php';
if (!$dev_mode) {
    require_once 'includes/auth.php';
}

// Add any specific queries for the managerial page here
$managerial_data = $conn->query("
    SELECT * FROM managerial_data
    ORDER BY created_at DESC
");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Halaman Manajerial</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
    <link href="../assets/css/dashboard.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-3">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
                    <h1 class="h4">Dashboard Manajerial</h1>
                </div>

                <!-- Main Content Section -->
                <div class="card mb-4">
                    <div class="card-header py-2">
                        <h5 class="mb-0">Data Manajerial</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Nama</th>
                                        <th>Tanggal</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while($row = $managerial_data->fetch_assoc()): ?>
                                    <tr>
                                        <td><?= $row['id'] ?></td>
                                        <td><?= htmlspecialchars($row['name']) ?></td>
                                        <td><?= date('d M Y', strtotime($row['created_at'])) ?></td>
                                        <td>
                                            <span class="badge bg-<?= $row['status'] == 'active' ? 'success' : 'secondary' ?>">
                                                <?= ucfirst($row['status']) ?>
                                            </span>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Additional Managerial Sections -->
                <div class="row">
                    <div class="col-md-6">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0">Statistik</h5>
                            </div>
                            <div class="card-body">
                                <!-- Placeholder for charts/statistics -->
                                <div id="managerialStats" style="height: 300px;">
                                    <p class="text-muted">Grafik statistik akan ditampilkan di sini</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0">Aksi Cepat</h5>
                            </div>
                            <div class="card-body">
                                <div class="d-grid gap-2">
                                    <button class="btn btn-primary">Tambah Data</button>
                                    <button class="btn btn-outline-secondary">Generate Laporan</button>
                                    <button class="btn btn-outline-info">Ekspor Data</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Add any additional JS for managerial features here -->
</body>
</html>