<?php
require_once 'includes/config.php';
//require_once 'includes/auth.php';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $date = $_POST['date'];
    $procurement_type = $_POST['procurement_type'];
    $spotlight = $_POST['spotlight'];
    $due_date = $_POST['due_date'];
    $notes = $_POST['notes'];

    $stmt = $conn->prepare("INSERT INTO procurements (name, date, procurement_type, spotlight, due_date, notes) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssss", $name, $date, $procurement_type, $spotlight, $due_date, $notes);
    $stmt->execute();
    $stmt->close();

    header("Location: procurement.php?success=1");
    exit();
}

// Fetch existing procurements
$procurements = $conn->query("SELECT * FROM procurements ORDER BY date DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pengadaan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-3">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
                    <h1 class="h2">Data Pengadaan</h1>
                    <div class="btn-group">
                        <a href="procurement.php" class="btn btn-sm btn-outline-secondary">Daftar Pengadaan</a>
                        <a href="procurement_detail.php" class="btn btn-sm btn-outline-secondary active">Detail Pengadaan</a>
                        <a href="procurement_todos.php" class="btn btn-sm btn-outline-secondary">To-Do List</a>
                        <a href="procurement_meetings.php" class="btn btn-sm btn-outline-secondary">Notulen Rapat</a>
                    </div>
                </div>

                <!-- Add filter dropdown -->
                <div class="mb-3">
                    <select class="form-select" id="filterPengadaan" style="width: 200px;">
                        <option value="">Filter by Jenis Pengadaan</option>
                        <option value="PPDB">PPDB</option>
                        <option value="Sekolah">Sekolah</option>
                        <option value="Buku">Buku</option>
                        <option value="Multimedia">Multimedia</option>
                        <option value="Lainnya">Lainnya</option>
                    </select>
                </div>

                <?php if (isset($_GET['success'])): ?>
                <div class="alert alert-success">Data pengadaan berhasil disimpan!</div>
                <?php endif; ?>

                <!-- Add Procurement Form -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5>Tambah Pengadaan Baru</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST">
                            <div class="mb-3">
                                <label class="form-label">Nama Pengadaan</label>
                                <input type="text" class="form-control" name="name" required>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Tanggal</label>
                                        <input type="date" class="form-control" name="date" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Jenis Pengadaan</label>
                                        <select class="form-select" name="procurement_type" required>
                                            <option value="PPDB">PPDB</option>
                                            <option value="Sekolah">Sekolah</option>
                                            <option value="Buku">Buku</option>
                                            <option value="Multimedia">Multimedia</option>
                                            <option value="Lainnya">Lainnya</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Spotlight</label>
                                        <select class="form-select" name="spotlight" required>
                                            <option value="Pengawasan Khusus">Pengawasan Khusus</option>
                                            <option value="Pengawasan Umum">Pengawasan Umum</option>
                                            <option value="Normal" selected>Normal</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Due Date</label>
                                        <input type="date" class="form-control" name="due_date">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Catatan</label>
                                <textarea class="form-control" name="notes" rows="3"></textarea>
                            </div>
                            
                            <button type="submit" class="btn btn-primary">Simpan</button>
                        </form>
                    </div>
                </div>

                <!-- Procurement List -->
                <div class="card">
                    <div class="card-header">
                        <h5>Daftar Pengadaan</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Tanggal</th>
                                        <th>Nama</th>
                                        <th>Jenis</th>
                                        <th>Spotlight</th>
                                        <th>Due Date</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while($procurement = $procurements->fetch_assoc()): ?>
                                    <tr>
                                        <td><?= date('d M Y', strtotime($procurement['date'])) ?></td>
                                        <td><?= htmlspecialchars($procurement['name']) ?></td>
                                        <td><?= htmlspecialchars($procurement['procurement_type']) ?></td>
                                        <td><?= htmlspecialchars($procurement['spotlight']) ?></td>
                                        <td><?= $procurement['due_date'] ? date('d M Y', strtotime($procurement['due_date'])) : '-' ?></td>
                                        <td>
                                            <a href="procurement_detail.php?id=<?= $procurement['id'] ?>" class="btn btn-sm btn-info">Detail</a>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>