<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';

// Debug - log the incoming data
error_log("Comment submission: ".print_r($_POST, true));

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $source_type = $_POST['source_type'];
    $source_id = (int)$_POST['source_id'];
    $comment = trim($_POST['comment']);
    $type = $_POST['comment_type'];
    $username = $_SESSION['username'];
    
    // Debug
    error_log("Processing comment from $username for $source_type $source_id");
    
    if (!empty($comment)) {
        $stmt = $conn->prepare("
            INSERT INTO unified_comments 
            (source_type, source_id, comment, type, created_by)
            VALUES (?, ?, ?, ?, ?)
        ") or die("Prepare failed: ".$conn->error);
        
        $stmt->bind_param("sisss", $source_type, $source_id, $comment, $type, $username);
        
        if ($stmt->execute()) {
            error_log("Comment saved successfully");
            header("Location: procurement_detail.php?id=$source_id");
            exit();
        } else {
            error_log("Error saving comment: ".$conn->error);
            die("Error: " . $conn->error);
        }
    }
}
?>