<?php
require_once 'includes/config.php';
//require_once 'includes/auth.php';

$id = $_GET['id'] ?? null;
if (!$id) {
    header("Location: procurement.php");
    exit();
}

// Get procurement details
// Replace the procurement query with this:
$stmt = $conn->prepare("SELECT * FROM procurements WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$procurement = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$procurement) {
    header("Location: procurement.php");
    exit();
}

// Get todos for this procurement
// Replace with prepared statement:
$stmt = $conn->prepare("SELECT * FROM procurement_todos WHERE procurement_id = ? ORDER BY due_date");
$stmt->bind_param("i", $id);
$stmt->execute();
$todos = $stmt->get_result();

// Get meetings for this procurement
// Replace with prepared statement:
$stmt = $conn->prepare("SELECT * FROM procurement_meetings WHERE procurement_id = ? ORDER BY meeting_date DESC");
$stmt->bind_param("i", $id);
$stmt->execute();
$meetings = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Detail Pengadaan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .info-card {
            margin-bottom: 20px;
        }
        .section-title {
            margin-top: 30px;
            margin-bottom: 15px;
            padding-bottom: 5px;
            border-bottom: 1px solid #dee2e6;
        }
        /* Add these new styles */
        // Remove these comment-related styles:
        .comment-item {
            padding: 10px 0;
            border-bottom: 1px solid #eee;
            margin-bottom: 10px;
        }
        .comment-header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
        }
        .comment-body p {
            margin-bottom: 0;
        }
        .comment-manajerial {
            border-left: 4px solid #fd7e14;
        }
        .comment-operator {
            border-left: 4px solid #0d6efd;
        }
        .comment-keuangan {
            border-left: 4px solid #ffc107;
        }
        .comment-acd {
            border-left: 4px solid #6f42c1;
        }
        .comment-general {
            border-left: 4px solid #6c757d;
        }
        .bg-manajerial {
            background-color: #fd7e14 !important;
        }
        .bg-operator {
            background-color: #0d6efd !important;
        }
        .bg-keuangan {
            background-color: #ffc107 !important;
        }
        .bg-acd {
            background-color: #6f42c1 !important;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-3">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
                    <h1 class="h2">Detail Pengadaan: <?= htmlspecialchars($procurement['name']) ?></h1>
                </div>

                <!-- Info Pengadaan -->
                <div class="card info-card">
                    <div class="card-header">
                        <h5>Informasi Pengadaan</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <p><strong>Tanggal:</strong> <?= date('d M Y', strtotime($procurement['date'])) ?></p>
                                <p><strong>Jenis:</strong> <?= htmlspecialchars($procurement['procurement_type']) ?></p>
                                <p><strong>Status:</strong> 
                                    <span class="badge bg-<?= 
                                        $procurement['spotlight'] == 'Pengawasan Khusus' ? 'danger' : 
                                        ($procurement['spotlight'] == 'Pengawasan Umum' ? 'warning' : 'primary')
                                    ?>">
                                        <?= htmlspecialchars($procurement['spotlight']) ?>
                                    </span>
                                </p>
                            </div>
                            <div class="col-md-6">
                                <p><strong>Due Date:</strong> <?= $procurement['due_date'] ? date('d M Y', strtotime($procurement['due_date'])) : '-' ?></p>
                                <p><strong>Catatan:</strong><br><?= nl2br(htmlspecialchars($procurement['notes'])) ?></p>
                                
                                <!-- Remove the entire help request dropdown and status display section -->
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Combined To-Do and Meeting Notes Section -->
                <div class="row">
                    <!-- Left Column (8 units) -->
                    <div class="col-md-8">
                        <!-- To-Do List Section -->
                        <h4 class="section-title">To-Do List</h4>
                        <div class="card mb-4">
                            <div class="card-body">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Task</th>
                                            <th>Due Date</th>
                                            <th>Status</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while($todo = $todos->fetch_assoc()): ?>
                                        <tr>
                                            <td><?= htmlspecialchars($todo['title']) ?></td>
                                            <td><?= date('d M Y', strtotime($todo['due_date'])) ?></td>
                                            <td>
                                                <span class="badge <?= $todo['status'] === 'completed' ? 'bg-success' : 'bg-warning' ?>">
                                                    <?= ucfirst($todo['status']) ?>
                                                </span>
                                            </td>
                                            <td>
                                                <button class="btn btn-sm btn-outline-primary toggle-status" 
                                                        data-todo-id="<?= $todo['id'] ?>"
                                                        data-status="<?= $todo['status'] ?>">
                                                    Toggle Status
                                                </button>
                                            </td>
                                        </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addTodoModal">
                                    Tambah To-Do
                                </button>
                            </div>
                        </div>
                        
                        <!-- Meeting Notes Section -->
                        <h4 class="section-title">Notulen Rapat</h4>
                        <div class="card">
                            <div class="card-body">
                                <div class="list-group">
                                    <?php while($meeting = $meetings->fetch_assoc()): ?>
                                    <div class="list-group-item">
                                        <div class="d-flex justify-content-between">
                                            <h6>Rapat <?= date('d M Y H:i', strtotime($meeting['meeting_date'])) ?></h6>
                                            <small>Oleh: <?= htmlspecialchars($meeting['created_by']) ?></small>
                                        </div>
                                        <p><?= nl2br(htmlspecialchars($meeting['notes'])) ?></p>
                                    </div>
                                    <?php endwhile; ?>
                                </div>
                                <button class="btn btn-primary mt-3" data-bs-toggle="modal" data-bs-target="#addMeetingModal">
                                    Tambah Notulen
                                </button>
                            </div>
                        </div>
                    </div>

                    // Replace the entire right column (4 units) section with just an empty div
                    <div class="col-md-4">
                    <!-- Space reserved for future features -->
                    </div>
                </div>
            </main>
        </div>
    </div>

    <!-- Add Todo Modal -->
    <div class="modal fade" id="addTodoModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah To-Do</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form action="procurement_add_todo.php" method="POST">
                        <input type="hidden" name="procurement_id" value="<?= $id ?>">
                        <div class="mb-3">
                            <label class="form-label">Task</label>
                            <input type="text" class="form-control" name="title" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Due Date</label>
                            <input type="date" class="form-control" name="due_date" required>
                        </div>
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Meeting Modal -->
    <div class="modal fade" id="addMeetingModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Notulen Rapat</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form action="procurement_add_meeting.php" method="POST">
                        <input type="hidden" name="procurement_id" value="<?= $id ?>">
                        <div class="mb-3">
                            <label class="form-label">Tanggal/Jam Rapat</label>
                            <input type="datetime-local" class="form-control" name="meeting_date" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Notulen</label>
                            <textarea class="form-control" name="notes" rows="5" required></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    // Toggle todo status
    document.querySelectorAll('.toggle-status').forEach(button => {
        button.addEventListener('click', async function() {
            const todoId = this.getAttribute('data-todo-id');
            const currentStatus = this.getAttribute('data-status');
            const newStatus = currentStatus === 'completed' ? 'pending' : 'completed';
            
            try {
                const response = await fetch('procurement_toggle_todo.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: `id=${todoId}&status=${newStatus}`
                });
                
                if (response.ok) {
                    location.reload();
                } else {
                    alert('Gagal mengupdate status');
                }
            } catch (error) {
                console.error('Error:', error);
                alert('Terjadi kesalahan');
            }
        });
    });

    // Comment form submission - update selector to match actual form
    // Remove this section from the script:
    document.querySelector('form[action="procurement_add_comment.php"]').addEventListener('submit', function(e) {
        e.preventDefault();
        const form = this;
        const formData = new FormData(form);
        
        fetch(form.action, {
            method: 'POST',
            body: formData
        })
        .then(response => {
            if (response.ok) {
                location.reload();
            } else {
                alert('Gagal mengirim komentar');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Terjadi kesalahan');
        });
    });
    </script> 
    
</script> 
    
</body>
</html>