<?php
require_once 'includes/config.php';
require_once 'includes/auth.php';

// Get filter parameters
$filter_type = $_GET['type'] ?? '';
$filter_status = $_GET['status'] ?? '';

// Build base query
$query = "SELECT t.*, p.name as procurement_name, p.procurement_type 
          FROM procurement_todos t
          JOIN procurements p ON t.procurement_id = p.id";

// Add filters
$where = [];
$params = [];
if ($filter_type) {
    $where[] = "p.procurement_type = ?";
    $params[] = $filter_type;
}
if ($filter_status) {
    $where[] = "t.status = ?";
    $params[] = $filter_status;
}

if (!empty($where)) {
    $query .= " WHERE " . implode(" AND ", $where);
}

$query .= " ORDER BY t.due_date ASC";

// Prepare and execute query
$stmt = $conn->prepare($query);
if (!empty($params)) {
    $types = str_repeat('s', count($params));
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
$todos = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>To-Do List Pengadaan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-3">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
                    <h1 class="h2">To-Do List Pengadaan</h1>
                    <div class="btn-group">
                        <a href="procurement.php" class="btn btn-sm btn-outline-secondary">Daftar Pengadaan</a>
                        <a href="procurement_detail.php" class="btn btn-sm btn-outline-secondary">Detail Pengadaan</a>
                        <a href="procurement_todos.php" class="btn btn-sm btn-outline-secondary active">To-Do List</a>
                        <a href="procurement_meetings.php" class="btn btn-sm btn-outline-secondary">Notulen Rapat</a>
                    </div>
                </div>

                <!-- Filter Section -->
                <div class="card mb-4">
                    <div class="card-body">
                        <form method="GET" class="row">
                            <div class="col-md-4">
                                <label class="form-label">Jenis Pengadaan</label>
                                <select class="form-select" name="type">
                                    <option value="">Semua Jenis</option>
                                    <option value="PPDB" <?= $filter_type === 'PPDB' ? 'selected' : '' ?>>PPDB</option>
                                    <option value="Sekolah" <?= $filter_type === 'Sekolah' ? 'selected' : '' ?>>Sekolah</option>
                                    <option value="Buku" <?= $filter_type === 'Buku' ? 'selected' : '' ?>>Buku</option>
                                    <option value="Multimedia" <?= $filter_type === 'Multimedia' ? 'selected' : '' ?>>Multimedia</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Status</label>
                                <select class="form-select" name="status">
                                    <option value="">Semua Status</option>
                                    <option value="pending" <?= $filter_status === 'pending' ? 'selected' : '' ?>>Pending</option>
                                    <option value="completed" <?= $filter_status === 'completed' ? 'selected' : '' ?>>Completed</option>
                                </select>
                            </div>
                            <div class="col-md-4 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">Filter</button>
                                <a href="procurement_todos.php" class="btn btn-outline-secondary ms-2">Reset</a>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- To-Do List Table -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Task</th>
                                        <th>Pengadaan</th>
                                        <th>Jenis</th>
                                        <th>Due Date</th>
                                        <th>Status</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($todos as $todo): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($todo['title']) ?></td>
                                        <td><?= htmlspecialchars($todo['procurement_name']) ?></td>
                                        <td><?= htmlspecialchars($todo['procurement_type']) ?></td>
                                        <td><?= date('d M Y', strtotime($todo['due_date'])) ?></td>
                                        <td>
                                            <span class="badge <?= $todo['status'] === 'completed' ? 'bg-success' : 'bg-warning' ?>">
                                                <?= ucfirst($todo['status']) ?>
                                            </span>
                                        </td>
                                        <td>
                                            <a href="procurement_detail.php?id=<?= $todo['procurement_id'] ?>" class="btn btn-sm btn-info">Detail</a>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>