<?php
require_once 'includes/config.php';

$tables = [
    "CREATE TABLE IF NOT EXISTS activity_todos (
        id INT AUTO_INCREMENT PRIMARY KEY,
        activity_id INT NOT NULL,
        title VARCHAR(255) NOT NULL,
        description TEXT,
        priority ENUM('low', 'medium', 'high') DEFAULT 'medium',
        due_date DATE,
        assigned_to VARCHAR(100),
        status ENUM('pending', 'completed') DEFAULT 'pending',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (activity_id) REFERENCES activities(id) ON DELETE CASCADE
    )",
    
    "CREATE TABLE IF NOT EXISTS activity_meeting_notes (
        id INT AUTO_INCREMENT PRIMARY KEY,
        activity_id INT NOT NULL,
        meeting_date DATETIME NOT NULL,
        notes TEXT NOT NULL,
        created_by VARCHAR(100) NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (activity_id) REFERENCES activities(id) ON DELETE CASCADE
    )"
];

foreach ($tables as $sql) {
    if ($conn->query($sql) === TRUE) {
        echo "Table created successfully: " . explode(" ", $sql)[5] . "<br>";
    } else {
        echo "Error creating table: " . $conn->error . "<br>";
    }
}

echo "Database setup completed!";
?>