<?php
require_once 'includes/config.php';
//require_once 'includes/auth.php';

$todos = $conn->query("
    SELECT ut.*, 
    CASE 
        WHEN source_type = 'activity' THEN a.name
        WHEN source_type = 'procurement' THEN p.name
        WHEN source_type = 'focus' THEN f.name
    END as source_name
    FROM unified_todos ut
    LEFT JOIN activities a ON source_type = 'activity' AND a.id = ut.source_id
    LEFT JOIN procurement p ON source_type = 'procurement' AND p.id = ut.source_id
    LEFT JOIN focus f ON source_type = 'focus' AND f.id = ut.source_id
    ORDER BY due_date
");
?>

<!-- HTML table to display all todos from different sources -->
<table class="table">
    <thead>
        <tr>
            <th>Source</th>
            <th>Divisi</th>
            <th>Task</th>
            <th>Keterangan</th>
            <th>Due Date</th>
            <th>Status</th>
        </tr>
    </thead>
    <tbody>
        <?php while($todo = $todos->fetch_assoc()): ?>
        <tr>
            <td><?= htmlspecialchars($todo['source_name']) ?> (<?= $todo['source_type'] ?>)</td>
            <td><?= htmlspecialchars($todo['divisi']) ?></td>
            <td><?= htmlspecialchars($todo['title']) ?></td>
            <td><?= htmlspecialchars($todo['keterangan']) ?></td>
            <td><?= date('d M Y', strtotime($todo['due_date'])) ?></td>
            <td><?= ucfirst($todo['status']) ?></td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>