<?php
require_once 'includes/config.php';
// Uncomment the line below if you need authentication
// require_once 'includes/auth.php';

$page_title = "Jadwal Peminjaman Kendaraan";

// Fetch all vehicle loans, joining with vehicle details
// Consider adding pagination for large datasets later
$loans_query = "
    SELECT 
        vl.id, vl.borrower_name, vl.start_date, vl.end_date, vl.purpose, vl.status, vl.created_at,
        v.name as vehicle_name, v.license_plate
    FROM vehicle_loans vl
    JOIN vehicles v ON vl.vehicle_id = v.id
    ORDER BY vl.start_date DESC, vl.created_at DESC 
"; // Order by most recent start date first

$loans_result = $conn->query($loans_query);

// Check for query errors (optional but recommended)
if (!$loans_result) {
    error_log("Error fetching vehicle loans: " . $conn->error);
    // You might want to display an error message to the user
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $page_title ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet"> <!-- Your custom styles -->
    <link href="../assets/css/dashboard.css" rel="stylesheet"> <!-- Specific dashboard styles -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>

            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-3">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
                    <h1 class="h4"><?= $page_title ?></h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <a href="vehicle_loan_add.php" class="btn btn-sm btn-primary"> <!-- Link to add loan page -->
                            <i class="fas fa-plus"></i> Tambah Peminjaman
                        </a>
                         <a href="vehicle_schedule_dashboard.php" class="btn btn-sm btn-outline-secondary ms-2">
                            <i class="fas fa-calendar-alt"></i> Lihat Dashboard Jadwal
                        </a>
                    </div>
                </div>

                <!-- Loan List Table -->
                <div class="card">
                    <div class="card-header">
                        Daftar Semua Peminjaman Kendaraan
                    </div>
                    <div class="card-body">
                        <?php if ($loans_result && $loans_result->num_rows > 0): ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover table-sm">
                                    <thead>
                                        <tr>
                                            <th>Kendaraan</th>
                                            <th>Peminjam</th>
                                            <th>Tanggal Mulai</th>
                                            <th>Tanggal Selesai</th>
                                            <th>Keperluan</th>
                                            <th>Status</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while($loan = $loans_result->fetch_assoc()): ?>
                                            <?php
                                                // Determine status badge color
                                                $status_badge = 'bg-secondary'; // Default
                                                switch ($loan['status']) {
                                                    case 'scheduled':
                                                        $status_badge = 'bg-primary'; // Or bg-warning text-dark
                                                        break;
                                                    case 'ongoing':
                                                        $status_badge = 'bg-success';
                                                        break;
                                                    case 'completed':
                                                        $status_badge = 'bg-secondary';
                                                        break;
                                                    case 'cancelled':
                                                        $status_badge = 'bg-danger';
                                                        break;
                                                }
                                            ?>
                                            <tr>
                                                <td><?= htmlspecialchars($loan['vehicle_name']) ?> (<?= htmlspecialchars($loan['license_plate']) ?>)</td>
                                                <td><?= htmlspecialchars($loan['borrower_name']) ?></td>
                                                <td><?= date('d M Y', strtotime($loan['start_date'])) ?></td>
                                                <td><?= date('d M Y', strtotime($loan['end_date'])) ?></td>
                                                <td><?= nl2br(htmlspecialchars($loan['purpose'] ?? '-')) ?></td>
                                                <td><span class="badge <?= $status_badge ?>"><?= ucfirst($loan['status']) ?></span></td>
                                                <td>
                                                    <a href="vehicle_loan_detail.php?id=<?= $loan['id'] ?>" class="btn btn-xs btn-outline-info" title="Lihat Detail">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <!-- Add Edit/Cancel buttons if applicable and based on status -->
                                                    <?php if (in_array($loan['status'], ['scheduled', 'ongoing'])): ?>
                                                        <a href="vehicle_loan_edit.php?id=<?= $loan['id'] ?>" class="btn btn-xs btn-outline-primary ms-1" title="Edit">
                                                            <i class="fas fa-pencil-alt"></i>
                                                        </a>
                                                        <!-- Add Cancel button with confirmation -->
                                                        <a href="vehicle_loan_cancel.php?id=<?= $loan['id'] ?>" class="btn btn-xs btn-outline-danger ms-1" title="Batalkan" onclick="return confirm('Apakah Anda yakin ingin membatalkan peminjaman ini?');">
                                                            <i class="fas fa-times-circle"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                            <!-- Add pagination controls here if implemented -->
                        <?php else: ?>
                            <p class="text-center text-muted">Belum ada data peminjaman kendaraan.</p>
                        <?php endif; ?>
                        <?php if (!$loans_result): ?>
                             <p class="text-center text-danger">Terjadi kesalahan saat mengambil data peminjaman.</p>
                        <?php endif; ?>
                    </div>
                </div>

            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>