<?php
require_once 'includes/config.php';
// Uncomment the line below if you need authentication
// require_once 'includes/auth.php';

// Fetch all vehicles
$vehicles_query = "
    SELECT 
        id, name, license_plate, brand, year, status, 
        stnk_number, engine_number, chassis_number 
    FROM vehicles 
    ORDER BY name ASC
";
$vehicles_result = $conn->query($vehicles_query);

// Check for query errors (optional but recommended)
if (!$vehicles_result) {
    error_log("Error fetching vehicles: " . $conn->error);
    // You might want to display an error message to the user
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Kendaraan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet"> <!-- Your custom styles -->
    <link href="../assets/css/dashboard.css" rel="stylesheet"> <!-- Specific dashboard styles -->
    <!-- Add links to Font Awesome if you use icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css"> 
</head>
<body>
    <?php include 'includes/header.php'; ?>

    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>

            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-3">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
                    <h1 class="h4">Data Kendaraan</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <a href="vehicle_add.php" class="btn btn-sm btn-primary"> <!-- Link to add vehicle page -->
                            <i class="fas fa-plus"></i> Tambah Kendaraan
                        </a>
                    </div>
                </div>

                <!-- Vehicle List Table -->
                <div class="card">
                    <div class="card-header">
                        Daftar Semua Kendaraan
                    </div>
                    <div class="card-body">
                        <?php if ($vehicles_result && $vehicles_result->num_rows > 0): ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover table-sm">
                                    <thead>
                                        <tr>
                                            <th>Nama</th>
                                            <th>No. Polisi</th>
                                            <th>Merk</th>
                                            <th>Tahun</th>
                                            <th>Status</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while($vehicle = $vehicles_result->fetch_assoc()): ?>
                                            <?php
                                                // Determine status badge color
                                                $status_badge = 'bg-secondary'; // Default (e.g., inactive)
                                                switch ($vehicle['status']) {
                                                    case 'available':
                                                        $status_badge = 'bg-success';
                                                        break;
                                                    case 'on_loan':
                                                        $status_badge = 'bg-warning text-dark';
                                                        break;
                                                    case 'maintenance':
                                                        $status_badge = 'bg-info text-dark';
                                                        break;
                                                    case 'inactive':
                                                        $status_badge = 'bg-danger';
                                                        break;
                                                }
                                            ?>
                                            <tr>
                                                <td><?= htmlspecialchars($vehicle['name']) ?></td>
                                                <td><?= htmlspecialchars($vehicle['license_plate']) ?></td>
                                                <td><?= htmlspecialchars($vehicle['brand'] ?? '-') ?></td>
                                                <td><?= htmlspecialchars($vehicle['year'] ?? '-') ?></td>
                                                <td><span class="badge <?= $status_badge ?>"><?= ucfirst(str_replace('_', ' ', $vehicle['status'])) ?></span></td>
                                                <td>
                                                    <a href="vehicle_detail.php?id=<?= $vehicle['id'] ?>" class="btn btn-xs btn-outline-info" title="Lihat Detail">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="vehicle_edit.php?id=<?= $vehicle['id'] ?>" class="btn btn-xs btn-outline-primary ms-1" title="Edit">
                                                        <i class="fas fa-pencil-alt"></i>
                                                    </a>
                                                    <!-- Add Delete button with confirmation later -->
                                                    <!-- 
                                                    <a href="vehicle_delete.php?id=<?= $vehicle['id'] ?>" class="btn btn-xs btn-outline-danger ms-1" title="Hapus" onclick="return confirm('Apakah Anda yakin ingin menghapus kendaraan ini?');">
                                                        <i class="fas fa-trash-alt"></i>
                                                    </a> 
                                                    -->
                                                </td>
                                            </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <p class="text-center text-muted">Belum ada data kendaraan.</p>
                        <?php endif; ?>
                        <?php if (!$vehicles_result): ?>
                             <p class="text-center text-danger">Terjadi kesalahan saat mengambil data kendaraan.</p>
                        <?php endif; ?>
                    </div>
                </div>

            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Font Awesome script already included via CDN link in head -->
</body>
</html>