<?php
function displayComments($conn, $source_type, $source_id) {
    $comments = $conn->query("
        SELECT c.*, u.name as created_by_name 
        FROM unified_comments c
        JOIN users u ON c.created_by = u.username
        WHERE c.source_type = '$source_type' AND c.source_id = $source_id
        ORDER BY c.created_at DESC
    ");
    ?>
    <div class="comment-system">
        <h4 class="section-title">Komentar</h4>
        <div class="card mb-4">
            <div class="card-body">
                <div class="list-group mb-3" id="commentsContainer">
                    <?php if($comments->num_rows > 0): ?>
                        <?php while($comment = $comments->fetch_assoc()): ?>
                        <div class="comment-item comment-<?= $comment['type'] ?>">
                            <div class="comment-header">
                                <div>
                                    <strong><?= htmlspecialchars($comment['created_by_name']) ?></strong>
                                    <?php if($comment['type'] !== 'general'): ?>
                                        <span class="badge bg-<?= $comment['type'] ?>"><?= ucfirst($comment['type']) ?></span>
                                    <?php endif; ?>
                                </div>
                                <small class="text-muted">
                                    <?= date('d M Y H:i', strtotime($comment['created_at'])) ?>
                                </small>
                            </div>
                            <div class="comment-body">
                                <p><?= nl2br(htmlspecialchars($comment['comment'])) ?></p>
                                <?php if(!empty($comment['attachment'])): ?>
                                    <div class="mt-2">
                                        <a href="../uploads/comments/<?= htmlspecialchars($comment['attachment']) ?>" 
                                           class="btn btn-sm btn-outline-secondary" 
                                           target="_blank">
                                            <i class="bi bi-paperclip"></i> Lampiran
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <p class="text-muted">Belum ada komentar</p>
                    <?php endif; ?>
                </div>
                
                <form id="commentForm" action="add_comment.php" method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="source_type" value="<?= $source_type ?>">
                    <input type="hidden" name="source_id" value="<?= $source_id ?>">
                    <div class="mb-3">
                        <textarea class="form-control" name="comment" rows="3" placeholder="Tulis komentar..." required></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Tipe Komentar</label>
                        <select class="form-select" name="comment_type">
                            <option value="general">Umum</option>
                            <option value="manajerial">Manajerial</option>
                            <option value="operator">Operator</option>
                            <option value="keuangan">Keuangan</option>
                            <option value="acd">ACD</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Lampiran (opsional)</label>
                        <input type="file" class="form-control" name="attachment">
                    </div>
                    <button type="submit" class="btn btn-primary">Kirim Komentar</button>
                </form>
            </div>
        </div>
    </div>
    <?php
}
?>